<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Feeding extends Model
{

    use LogsActivity;
    
    protected $table = 'feedings';

    protected $fillable = [
        'feeding_date',
        'manager_id',
        'cooks_id',
        'aggregators_id',
        'school_id',
        'state',
        'day',
        'items',
        'unit_cost',
        'pupils',
        'amount_per_day',
        'amount_of_20_days',
        'total',
        'payable_amount',
        'paid',
        'status',
    ];


    protected static $logAttributes = ['*'];

    protected static $logName = 'Pupils';

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->useLogName('Pupils');
    }
    public function getDescriptionForEvent(string $eventName): string
    {
        return "Pupils has been {$eventName}.";
    }

    public function cooks()
    {
        return $this->hasOne(Cooks::class, 'id', 'cooks_id');
    } 

    public function aggregator()
    {
        return $this->hasOne(Aggregator::class, 'id', 'aggregators_id');
    } 


    public function school()
    {
        return $this->hasOne(School::class, 'id', 'school_id');
    } 

}
