<?php

namespace App\Http\Controllers;

use App\Helpers\ImageUpload;
use App\ProgramManager;
use App\School;
use App\User;
use Illuminate\Http\Request;
use Validator;

class ProgramManagerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $managers  = ProgramManager::all();
        return view('manager.index', compact('managers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $schools = School::pluck('name', 'id');
        return view('manager.create', compact('schools'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        $validator = Validator::make($request->all(),[
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:8',
            'photo' => 'mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
        ]);
        if($validator->fails()){
            return redirect()->back()->with('error', $validator->errors()->first())->withInput();
//            return redirect()->back()->withErrors($validator)->withInput();
        }

        if($request->hasFile('photo')) {
            $file=$request->file('photo');
            $input['photo']=ImageUpload::image_upload($file);
        }

        $user_input = array(
            'name' => $input['first_name']. ' '. $input['middle_name'],
            'email' => $input['email'],
            'password' => bcrypt($input['password'])
        );

        try{
            $user = User::create($user_input);
            $user->assignRole(1);
            $input['user_id'] = $user->id;
            $manager = ProgramManager::create($input);
            return redirect()->back()->with('success', 'Program Manager successfully created.');
        }catch(Exception $e){
            return redirect()->back()->with('error', $e->getMessage())->withInput();
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\ProgramManager  $programManager
     * @return \Illuminate\Http\Response
     */
    public function show(ProgramManager $programManager)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\ProgramManager  $programManager
     * @return \Illuminate\Http\Response
     */
    public function edit(ProgramManager $programManager)
    {
        $schools = School::pluck('name', 'id');
        return view('manager.edit', compact('programManager', 'schools'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\ProgramManager  $programManager
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ProgramManager $programManager)
    {
        $input = $request->all();
        $validator = Validator::make($request->all(),[
            'photo' => 'mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
        ]);
        if($validator->fails()){
            return redirect()->back()->with('error', $validator->errors()->first())->withInput();
        }

        if($request->hasFile('photo')) {
            $file=$request->file('photo');
            $input['photo']=ImageUpload::image_upload($file);
        }

        try{
            $programManager->update($input);
            return redirect()->back()->with('success', 'Program Manager updated.');
        }catch(Exception $e){
            return redirect()->back()->with('error', $e->getMessage())->withInput();
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ProgramManager  $programManager
     * @return \Illuminate\Http\Response
     */
    public function destroy(ProgramManager $programManager)
    {
        try {
            $programManager->delete();
            return redirect()->back()->with('success', 'Program Manager deleted');
        }
        catch(Exception $e){
            return redirect()->back()->with('error', $e->getMessage())->withInput();
        }
    }
}
