<?php

namespace App\Http\Controllers;

use App\Exports\SchoolExport;
use App\LocalGovernment;
use App\SchoolSponsor;
use App\Imports\SchoolImport;
use App\Notifications\NewSchoolNotification;
use App\State;
use App\User;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Facades\Excel;

class SchoolsSponsorsController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:school-list|school-create|school-edit|school-delete', ['only' => ['index', 'store']]);
        $this->middleware('permission:school-create', ['only' => ['create', 'store']]);
        $this->middleware('permission:school-edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:school-delete', ['only' => ['destroy']]);
    }
    public function sponsored_schools()
    {
        if (auth()->user()->hasrole('Admin')) {

            SchoolSponsor::where('seen', '=', 0)->update(['seen' => 1]);
            $schools = School::where('status', '=', 'Approved')->orderBy('id', 'DESC')->paginate(10);
        } else {
            $state = State::get_state_id(Auth::user()->state);
            SchoolSponsor::where('state', $state)->where('seen', '=', 0)->update(['seen' => 1]);
            $schools = SchoolSponsor::where('state', $state)->where('status', '=', 'Approved')->orderBy('id', 'DESC')->paginate(50);
        }

        return view('school.sponsored', compact('schools'));
    }
}