<?php

namespace App\Http\Controllers;

use App\Aggregator;
use App\Cooks;
use App\SuspendManage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SuspendManagementController extends Controller
{

    public function index()
    {
        $suspends = SuspendManage::orderBy('id', 'DESC')->get();
        return view('suspend.index', compact('suspends'));
    }
    
    public function make_suspend_request(Request $request)
    {
        $input = $request->all();
        $input['manager_id'] = Auth::id();
        try {
            SuspendManage::create($input);
            return redirect()->back()->with('success', 'Requested for suspend');
        }
        catch (\Exception $exception){
            return redirect()->back()->with('error', $exception->getMessage());
        }

    }

    public function approve_suspend($id)
    {
        $suspend = SuspendManage::find($id);
        if ($suspend->type == 'Aggregators'){
            $user = Aggregator::find($suspend->cooks_aggregators_id);
            $user->is_active = false;
            $user->save();
        }
        elseif ($suspend->type == 'Cooks'){
            $user = Cooks::find($suspend->cooks_aggregators_id);
            $user->is_active = false;
            $user->save();
        }
        $suspend->status = 'Approved';
        $suspend->save();
        return redirect()->back()->with('success', 'Suspend Request Approved');

    }

    public function decline_suspend($id)
    {
        $suspend = SuspendManage::find($id);
        $suspend->status = 'Declined';
        $suspend->save();
        return redirect()->back()->with('success', 'Suspend Request Declined');
    }
    public function delete_suspend_request($id)
    {
        $suspend = SuspendManage::findOrFail($id);
        $suspend->delete();
        return redirect()->back()->with('success', 'Suspend Request Deleted');
    }

}
