<?php

namespace App\Imports;

use App\PaymentStatus;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithStartRow;

class PaymentImport implements ToCollection, WithStartRow
{
    private $state;
    
    public function __construct($data)
    {
        $this->state = $data; 
    }
    
    
    
    public function collection(Collection $rows)
    {
        foreach ($rows as $row) 
        {
           PaymentStatus::updateOrCreate([
            'first_name'   => $row[0],
            'last_name'   => $row[1],
            'bank_name'    => $row[2],
            'account_no'  => $row[3],
            'month'   => $row[4],
            'state'   => $this->state,
            ],
            ['status'   => $row[5]
            ]);
        }
   }
   
   /**
        * @return int
        */
       public function startRow(): int
       {
           return 2;
       }
}
