<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Post extends Model
{
    use LogsActivity, HasSlug;

    protected $table = 'posts';

    protected $fillable = [
        'user_id',
        'title',
        'description',
        'thumbnail',
        'post_type',
        'slug',
        'status',
    ];

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug');
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->useLogName('Blog/Post');
    }

    public function getDescriptionForEvent(string $eventName): string
    {
        return "Blog/Post has been {$eventName}.";
    }

    public function getThumbnailAttribute($data)
    {
        return asset('/uploads') . '/' . $data;
    }

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }
}
