<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class SuspendManage extends Model
{
    use LogsActivity;

    protected $table = 'suspend_manages';

    protected $fillable = [
        'manager_id',
        'type',
        'cooks_aggregators_id',
        'reason',
        'status',
    ];

    protected static $logAttributes = ['*'];
    
    protected static $logName = 'Suspend Request';

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->useLogName('Suspend Request');
    }

    public function getDescriptionForEvent(string $eventName): string
    {
        return "Suspend Request has been {$eventName}.";
    }
}
