<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->integer('manager_id');
            $table->integer('total_cook');
            $table->integer('total_aggregator');
            $table->integer('total_pupils');
            $table->float('cook_amount');
            $table->float('aggregator_amount');
            $table->float('total_cook_amount');
            $table->float('total_aggregator_amount');
            $table->float('total_amount');
            $table->string('day');
            $table->integer('withdraw')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payments');
    }
}
