@extends('layouts.master')
@section('content')

    <div class="row">
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-0">Add Aggregator</h6>
                        </div>
                        <div class="text-right">
                            @can('aggregator-list')
                                <a href="{{ route('aggregators.index') }}" class="btn btn-success btn-sm mr-1"><i
                                        class="fas fa-align-justify mr-1"></i> Aggregator List</a>
                            @endcan
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    {!! Form::open(['route' => 'aggregators.store', 'class' => 'form-horizontal', 'files' => true]) !!}

                    @include('aggregator.fields')

                   <div class="row form-group">
                        <div class="col-md-4"></div>
                        <div class="col-md-8" style="margin-top: 10px;">
                            {{ Form::reset('Reset', array('class'=> 'btn btn-warning waves-effect waves-light','style'=>'background:#e68f3c!important')) }}
                            {{-- <button type="button" type = "reset" class="btn btn-warning waves-effect waves-light">Reset</button> --}}
                            {{ Form::submit('Create', array('class' => 'btn btn-primary waves-effect waves-light','style'=>'background:#7367f0!important')) }}</div>
                            {{-- <button type="button" type = "submit" class="btn btn-primary waves-effect waves-light">Create</button> --}}
                        </div>
                </div>

                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>


@endsection
