<div class="mb-3">
    <label for="company_name">Company Name *</label>
    <input type="text" name="company_name" id="company_name" class="form-control" required
        value="{{ old('company_name', $aggregator->company_name ?? '') }}">
</div>

<div class="mb-3">
    <label for="phone">Phone Number *</label>
    <input type="text" name="phone" id="phone" class="form-control" required
        value="{{ old('phone', $aggregator->phone ?? '') }}">
</div>

<div class="mb-3">
    <label for="email">Email *</label>
    <input type="email" name="email" id="email" class="form-control" required
        value="{{ old('email', $aggregator->email ?? '') }}">
</div>

<div class="mb-3">
    <label for="tin">TIN *</label>
    <input type="text" name="tin" id="tin" class="form-control" required
        value="{{ old('tin', $aggregator->tin ?? '') }}">
</div>

<div class="mb-3">
    <label for="account_no">Account No *</label>
    <input type="text" name="account_no" id="account_no" class="form-control" required
        value="{{ old('account_no', $aggregator->account_no ?? '') }}">
</div>

<div class="mb-3">
    <label for="bank">Bank Name *</label>
    <input type="text" name="bank" id="bank" class="form-control" required
        value="{{ old('bank', $aggregator->bank ?? '') }}">
</div>

<div class="mb-3">
    <label for="supply_items">Item Supplied *</label>
    <input type="text" name="supply_items" id="supply_items" class="form-control" required
        value="{{ old('supply_items', $aggregator->supply_items ?? '') }}">
</div>

<div class="mb-3">
    <label for="weekly_comsp">Weekly Consumption *</label>
    <input type="text" name="weekly_comsp" id="weekly_comsp" class="form-control" required
        value="{{ old('weekly_comsp', $aggregator->weekly_comsp ?? '') }}">
</div>

<div class="mb-3">
    <label for="cons_day">Day for Consumption *</label>
    <select name="cons_day[]" id="cons_day" class="form-control select2" multiple required>
        @php
            $days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
            $selectedDays = old('cons_day', $aggregator->cons_day ?? []);
        @endphp
        @foreach ($days as $day)
            <option value="{{ $day }}" {{ in_array($day, $selectedDays) ? 'selected' : '' }}>{{ $day }}</option>
        @endforeach
    </select>
</div>

<div class="mb-3">
    <label for="unit_cost">Unit Cost (N) *</label>
    <input type="text" name="unit_cost" id="unit_cost" class="form-control" required
        value="{{ old('unit_cost', $aggregator->unit_cost ?? '') }}">
</div>

<div class="mb-3">
    <label for="feed_pupils">Number of Children *</label>
    <input type="number" name="feed_pupils" id="feed_pupils" class="form-control" required
        value="{{ old('feed_pupils', $aggregator->feed_pupils ?? '') }}">
</div>

<div class="mb-3">
    <label for="week_cost">Cost Per Week *</label>
    <input type="number" name="week_cost" id="week_cost" class="form-control" required readonly
        value="{{ old('week_cost', $aggregator->week_cost ?? '') }}">
</div>

<div class="mb-3">
    <label for="amount_twenty">Amount for 20 Days *</label>
    <input type="number" name="amount_twenty" id="amount_twenty" class="form-control" required readonly
        value="{{ old('amount_twenty', $aggregator->amount_twenty ?? '') }}">
</div>

@if(auth()->user()->hasRole('Admin'))
    <div class="mb-3">
        <p><strong>Selected State ID:</strong> {{ old('state', $aggregator->state ?? 'none') }}</p>
        <label for="state">State *</label>
        <select name="state" id="state" class="form-control" required>
            <option value="">--please select--</option>
            @foreach ($states as $id => $name)
                <option value="{{ $id }}" {{ old('state', $aggregator->state ?? '') == $id ? 'selected' : '' }}>
                    {{ $name }}
                </option>
            @endforeach
        </select>

    </div>



    <div class="mb-3">
        <label for="is_verified">Verified *</label>
        <select name="is_verified" id="is_verified" class="form-control" required>
            <option value="0" {{ old('is_verified', $aggregator->is_verified ?? '') == 0 ? 'selected' : '' }}>Unverified
            </option>
            <option value="1" {{ old('is_verified', $aggregator->is_verified ?? '') == 1 ? 'selected' : '' }}>Verified
            </option>
        </select>
    </div>

    <div class="mb-3">
        <label for="status">Status *</label>
        <select name="status" id="status" class="form-control" required>
            @foreach (\App\Helpers\StaticData::account_status() as $statusValue => $statusLabel)
                <option value="{{ $statusValue }}" {{ old('status', $aggregator->status ?? '') == $statusValue ? 'selected' : '' }}>{{ $statusLabel }}</option>
            @endforeach
        </select>
    </div>
@else
    @if (Request::route()->named('aggregators.create'))
        <div class="mb-3">
            <label for="status">Status *</label>
            <select name="status" id="status" class="form-control" required>
                <option value="Pending" selected>Pending</option>
            </select>
        </div>
    @endif
@endif


@section('custom-js')
    <script>
        // Helper to calculate and update costs
        function calculateCosts() {
            const unitCost = parseFloat(document.querySelector('input[name="unit_cost"]').value) || 0;
            const pupils = parseInt(document.querySelector('input[name="feed_pupils"]').value) || 0;
            const days = document.querySelectorAll('select[name="cons_day[]"] option:checked').length;

            const weekCost = unitCost * pupils * days;
            const twentyDayCost = unitCost * pupils * 20;

            document.getElementById('week_cost').value = weekCost.toFixed(2);
            document.getElementById('amount_twenty').value = twentyDayCost.toFixed(2);
        }

        // Listen to changes
        document.addEventListener('DOMContentLoaded', function () {
            const unitCostInput = document.querySelector('input[name="unit_cost"]');
            const pupilsInput = document.querySelector('input[name="feed_pupils"]');
            const consDaySelect = document.querySelector('select[name="cons_day[]"]');

            if (unitCostInput && pupilsInput && consDaySelect) {
                unitCostInput.addEventListener('input', calculateCosts);
                pupilsInput.addEventListener('input', calculateCosts);
                consDaySelect.addEventListener('change', calculateCosts);
            }

            // Initial calculation on page load if values exist
            calculateCosts();
        });

        // For dropdowns
        $("#state").select2();
        $("#program_manager_id").select2();
    </script>
@endsection