@extends('layouts.app')
@section('content')
<!DOCTYPE html>

<html lang="en" class="light-style  customizer-hide" dir="ltr" data-theme="theme-default"
    data-assets-path="asset/assets/" data-template="vertical-menu-template">

<head>
    <meta charset="utf-8" />
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>{{ __('Login') }}</title>


    <meta name="description" content="Start your development with a Dashboard for Bootstrap 5" />
    <meta name="keywords" content="dashboard, bootstrap 5 dashboard, bootstrap 5 design, bootstrap 5">



    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="asset/assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet">

    <!-- Icons -->
    <link rel="stylesheet" href="asset/assets/vendor/fonts/fontawesome.css" />
    <link rel="stylesheet" href="asset/assets/vendor/fonts/tabler-icons.css" />
    <link rel="stylesheet" href="asset/assets/vendor/fonts/flag-icons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="asset/assets/vendor/css/rtl/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="asset/assets/vendor/css/rtl/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="asset/assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="asset/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="asset/assets/vendor/libs/node-waves/node-waves.css" />
    <link rel="stylesheet" href="asset/assets/vendor/libs/typeahead-js/typeahead.css" />
    <!-- Vendor -->
    <link rel="stylesheet" href="asset/assets/vendor/libs/formvalidation/dist/css/formValidation.min.css" />

    <!-- Page CSS -->
    <!-- Page -->
    <link rel="stylesheet" href="asset/assets/vendor/css/pages/page-auth.css">
    <!-- Helpers -->
    <script src="asset/assets/vendor/js/helpers.js"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Template customizer: To hide customizer set displayCustomizer value false in config.js.  -->
    <script src="asset/assets/vendor/js/template-customizer.js"></script>
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="asset/assets/js/config.js"></script>
</head>

<body>


    <!-- ?PROD Only: Google Tag Manager (noscript) (Default ThemeSelection: GTM-5DDHKGP, PixInvent: GTM-5J3LMKC) -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-5DDHKGP" height="0" width="0"
            style="display: none; visibility: hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->

    <!-- Content -->

    <div class="authentication-wrapper authentication-cover authentication-bg">
        <div class="authentication-inner row">
            <!-- /Left Text -->
            <div class="d-none d-lg-flex col-lg-7 p-0">
                <div class="auth-cover-bg auth-cover-bg-color d-flex justify-content-center align-items-center">
                    <img src="asset/assets/img/illustrations/student.png" alt="auth-login-cover"
                        class="img-fluid my-5 auth-illustration"
                        data-app-light-img="illustrations/student.png"
                        data-app-dark-img="illustrations/student.png">

                    <img src="asset/assets/img/illustrations/bg-shape-image-light.png" alt="auth-login-cover"
                        class="platform-bg" data-app-light-img="illustrations/bg-shape-image-light.png"
                        data-app-dark-img="illustrations/bg-shape-image-dark.png">
                </div>
            </div>
            <!-- /Left Text -->

            <!-- Login -->
            <div class="d-flex col-12 col-lg-5 align-items-center p-sm-5 p-4">
                <div class="w-px-400 mx-auto">
                    <!-- Logo -->
                    <div class="app-brand mb-4 d-flex justify-content-center">
                        <a href="index.html" class="app-brand-link gap-2">
                            <span class="">
                                <img src="backend/dist/img/logo/pigeon-icon-box.png" alt="" height="150" width="150">
                            </span>
                        </a>
                    </div>
                    <!-- /Logo -->
                    <h3 class="mb-1 fw-bold">Welcome to NHGSFP! 👋</h3>
                    <p class="mb-4">Please sign-in to your account and start the adventure</p>

                    <form id="formAuthentication" class="mb-3" action="{{ route('login') }}" method="POST">
                        <div class="mb-3">
                            <label for="email" class="form-label">{{ __('E-Mail Address') }}</label>
                            <input type="text" class="form-control form-control @error('email') is-invalid @enderror"
                                id="email" name="email" placeholder="Enter your email or username" autofocus>
                            @error('email')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <div class="mb-3 form-password-toggle">
                            <div class="d-flex justify-content-between">
                                <label class="form-label" for="password">{{ __('Password') }}</label>
                                <a href="auth-forgot-password-cover.html">
                                    <small>Forgot Password?</small>
                                </a>
                            </div>
                            <div class="input-group input-group-merge">
                                <input type="password" id="password" class="form-control" name="password"
                                    placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                    aria-describedby="password" required autocomplete="current-password" />
                                <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                                @error('password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="remember" id="remember"
                                    {{ old('remember') ? 'checked' : '' }}>
                                <label class="form-check-label" for="remember-me">
                                    {{ __('Remember Me') }}
                                </label>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary d-grid w-100">
                            {{ __('Login') }}
                        </button>
                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                    </form>

                    <!--<p class="text-center">-->
                    <!--  <span>New on our platform?</span>-->
                    <!--  <a href="auth-register-cover.html">-->
                    <!--    <span>Create an account</span>-->
                    <!--  </a>-->
                    <!--</p>-->

                    <!--<div class="divider my-4">-->
                    <!--  <div class="divider-text">or</div>-->
                    <!--</div>-->

                    <!--<div class="d-flex justify-content-center">-->
                    <!--  <a href="javascript:;" class="btn btn-icon btn-label-facebook me-3">-->
                    <!--    <i class="tf-icons fa-brands fa-facebook-f fs-5"></i>-->
                    <!--  </a>-->

                    <!--  <a href="javascript:;" class="btn btn-icon btn-label-google-plus me-3">-->
                    <!--    <i class="tf-icons fa-brands fa-google fs-5"></i>-->
                    <!--  </a>-->

                    <!--  <a href="javascript:;" class="btn btn-icon btn-label-twitter">-->
                    <!--    <i class="tf-icons fa-brands fa-twitter fs-5"></i>-->
                    <!--  </a>-->
                    <!--</div>-->
                </div>
            </div>
            <!-- /Login -->
        </div>
    </div>

    <!-- / Content -->

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="asset/assets/vendor/libs/jquery/jquery.js"></script>
    <script src="asset/assets/vendor/libs/popper/popper.js"></script>
    <script src="asset/assets/vendor/js/bootstrap.js"></script>
    <script src="asset/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="asset/assets/vendor/libs/node-waves/node-waves.js"></script>

    <script src="asset/assets/vendor/libs/hammer/hammer.js"></script>
    <script src="asset/assets/vendor/libs/i18n/i18n.js"></script>
    <script src="asset/assets/vendor/libs/typeahead-js/typeahead.js"></script>

    <script src="asset/assets/vendor/js/menu.js"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="asset/assets/vendor/libs/formvalidation/dist/js/FormValidation.min.js"></script>
    <script src="asset/assets/vendor/libs/formvalidation/dist/js/plugins/Bootstrap5.min.js"></script>
    <script src="asset/assets/vendor/libs/formvalidation/dist/js/plugins/AutoFocus.min.js"></script>

    <!-- Main JS -->
    <script src="asset/assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="asset/assets/js/pages-auth.js"></script>
    <script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    </script>
</body>

</html>
@endsection

<!-- beautify ignore:end -->