@extends('layouts.master')
@section('content')
  <!-- Content -->

  <div class="container-xxl flex-grow-1 container-p-y" style="padding-top:0px !important">
    <div class="app-chat card overflow-hidden">
    <div class="row g-0">
      <!-- Sidebar Left -->
      <div class="col app-chat-sidebar-left app-sidebar overflow-hidden" id="app-chat-sidebar-left">
      <div
        class="chat-sidebar-left-user sidebar-header d-flex flex-column justify-content-center align-items-center flex-wrap px-4 pt-5">
        <div class="avatar avatar-xl avatar-online">
        <img src="asset/assets/img/avatars/1.png" alt="Avatar" class="rounded-circle" />
        </div>
        <h5 class="mt-2 mb-0">John Doe</h5>
        <small>Admin</small>
        <i class="ti ti-x ti-sm cursor-pointer close-sidebar" data-bs-toggle="sidebar" data-overlay
        data-target="#app-chat-sidebar-left"></i>
      </div>
      <div class="sidebar-body px-4 pb-4">
        <div class="my-4">
        <p class="text-muted text-uppercase">About</p>
        <textarea id="chat-sidebar-left-user-about" class="form-control chat-sidebar-left-user-about mt-3" rows="4"
          maxlength="120">
  Dessert chocolate cake lemon drops jujubes. Biscuit cupcake ice cream bear claw brownie brownie marshmallow.</textarea>
        </div>
        <div class="my-4">
        <p class="text-muted text-uppercase">Status</p>
        <div class="d-grid gap-1">
          <div class="form-check form-check-success">
          <input name="chat-user-status" class="form-check-input" type="radio" value="active" id="user-active"
            checked />
          <label class="form-check-label" for="user-active">Active</label>
          </div>
          <div class="form-check form-check-danger">
          <input name="chat-user-status" class="form-check-input" type="radio" value="busy" id="user-busy" />
          <label class="form-check-label" for="user-busy">Busy</label>
          </div>
          <div class="form-check form-check-warning">
          <input name="chat-user-status" class="form-check-input" type="radio" value="away" id="user-away" />
          <label class="form-check-label" for="user-away">Away</label>
          </div>
          <div class="form-check form-check-secondary">
          <input name="chat-user-status" class="form-check-input" type="radio" value="offline"
            id="user-offline" />
          <label class="form-check-label" for="user-offline">Offline</label>
          </div>
        </div>
        </div>
        <div class="my-4">
        <p class="text-muted text-uppercase">Settings</p>
        <ul class="list-unstyled d-grid gap-2 me-3">
          <li class="d-flex justify-content-between align-items-center">
          <div>
            <i class="ti ti-message me-1"></i>
            <span class="align-middle">Two-step Verification</span>
          </div>
          <label class="switch switch-primary me-4">
            <input type="checkbox" class="switch-input" checked="" />
            <span class="switch-toggle-slider">
            <span class="switch-on"></span>
            <span class="switch-off"></span>
            </span>
          </label>
          </li>
          <li class="d-flex justify-content-between align-items-center">
          <div>
            <i class="ti ti-bell me-1"></i>
            <span class="align-middle">Notification</span>
          </div>
          <label class="switch switch-primary me-4">
            <input type="checkbox" class="switch-input" />
            <span class="switch-toggle-slider">
            <span class="switch-on"></span>
            <span class="switch-off"></span>
            </span>
          </label>
          </li>
          <li>
          <i class="ti ti-user-plus me-1"></i>
          <span class="align-middle">Invite Friends</span>
          </li>
          <li>
          <i class="ti ti-trash me-1"></i>
          <span class="align-middle">Delete Account</span>
          </li>
        </ul>
        </div>
        <div class="d-flex mt-4">
        <button class="btn btn-primary" data-bs-toggle="sidebar" data-overlay data-target="#app-chat-sidebar-left">
          Logout
        </button>
        </div>
      </div>
      </div>
      <!-- /Sidebar Left-->

      <!-- Chat & Contacts -->
      <div class="col app-chat-contacts app-sidebar flex-grow-0 overflow-hidden border-end" id="app-chat-contacts">
      <div class="sidebar-header">
        <div class="d-flex align-items-center me-3 me-lg-0">
        <div class="flex-shrink-0 avatar avatar-online me-3" data-bs-toggle="sidebar" data-overlay="app-overlay-ex"
          data-target="#app-chat-sidebar-left">
          <img class="user-avatar rounded-circle cursor-pointer" src="{{ Auth::user()->photo }}" alt="Avatar1" />
        </div>
        <div class="flex-grow-1 input-group input-group-merge rounded-pill">
          <span class="input-group-text" id="basic-addon-search31"><i class="ti ti-search"></i></span>
          <input type="text" class="form-control chat-search-input" placeholder="Search..." aria-label="Search..."
          aria-describedby="basic-addon-search31" />
        </div>
        </div>
        <i class="ti ti-x cursor-pointer d-lg-none d-block position-absolute mt-2 me-1 top-0 end-0" data-overlay
        data-bs-toggle="sidebar" data-target="#app-chat-contacts"></i>
      </div>
      <hr class="container-m-nx m-0" />
      <div class="sidebar-body">
        <div class="chat-contact-list-item-title">
        <h5 class="text-primary mb-0 px-4 pt-3 pb-2">Admins</h5>
        </div>
        <!-- Chats -->
        <div id="adminUsersList">


        <ul class="list-unstyled chat-contact-list" id="chat-list">

          <li class="chat-contact-list-item chat-list-item-0 d-none">
          <h6 class="text-muted mb-0">No Chats Found</h6>
          </li>
          {{--
          <pre>
          {{$state_admins}}
          </pre> --}}
          @foreach ($state_admins as $user)


        @if ($user->id != $id)

      <li class="chat-contact-list-item">
      <a class="d-flex align-items-center" data-id={{$user->id}} href="?reciverId={{$user->id}}">
      <div class="flex-shrink-0 avatar avatar-online">
      <img src="{{$user->photo}}" alt="Avatar" class="rounded-circle" />
      </div>
      <div class="chat-contact-info flex-grow-1 ms-2">
      @if($user->name == "Ariful Islam")

      <h6 class="chat-contact-name text-truncate m-0">Super Admin</h6>
    @else
      <h6 class="chat-contact-name text-truncate m-0">{{$user->name}}</h6>

    @endif
      <p class="chat-contact-status text-muted text-truncate mb-0">
        {{$user->user_type}}
      </p>
      </div>
      <small class="text-muted mb-auto">5 Minutes</small>
      </a>
      </li>
    @endif
      @endforeach

        </ul>
        </div>
        <!-- Contacts -->
        {{-- {{$data}} --}}
        <div id="usersList">
        <ul class="list-unstyled chat-contact-list mb-0" id="contact-list">
          <li class="chat-contact-list-item chat-contact-list-item-title">
          <h5 class="text-primary mb-0">Managers</h5>
          </li>
          <li class="chat-contact-list-item contact-list-item-0 d-none">
          <h6 class="text-muted mb-0">No Managers Found</h6>
          </li>
          @foreach ($data as $user)
        @if ($user->user_type != 'Admin')
      <li class="chat-contact-list-item">
      <a class="d-flex align-items-center" data-id={{$user->id}} href="?reciverId={{$user->id}}">
      <div class="flex-shrink-0 avatar avatar-offline">
      <img src="{{$user->photo}}" alt="Avatar" class="rounded-circle" />
      <!-- <img src="backend/dist/img/avatar5.png" alt="Avatar"
        class="rounded-circle" /> -->
      </div>
      <div class="chat-contact-info flex-grow-1 ms-2">
      <h6 class="chat-contact-name text-truncate m-0">{{$user->name}}</h6>
      <p class="chat-contact-status text-muted text-truncate mb-0">{{$user->user_type}}</p>
      </div>
      </a>
      </li>
    @endif
      @endforeach

        </ul>
        </div>
      </div>
      </div>
      <!-- /Chat contacts -->

      <!-- Chat History -->
      <div class="col app-chat-history bg-body" id="chatDiv">
      <div class="chat-history-wrapper">
        <div class="chat-history-header border-bottom">
        <div class="d-flex justify-content-between align-items-center">
          <div class="d-flex overflow-hidden align-items-center">
          <i class="ti ti-menu-2 ti-sm cursor-pointer d-lg-none d-block me-2" data-bs-toggle="sidebar"
            data-overlay data-target="#app-chat-contacts"></i>
          <div class="flex-shrink-0 avatar">
            @foreach ($ReciverData as $user)
          @if($user->photo != "")
        <img src="uploads/{{$user->photo}}" alt="Avatar" class="rounded-circle" data-bs-toggle="sidebar"
        data-overlay data-target="#app-chat-sidebar-right" />
      @else
      <img src="asset/assets/img/avatars/2.png" alt="Avatar" class="rounded-circle" data-bs-toggle="sidebar"
      data-overlay data-target="#app-chat-sidebar-right" />
    @endif
          </div>
          <div class="chat-contact-info flex-grow-1 ms-2">


          @if($user->name == "Ariful Islam")
        <h6 class="m-0">Super Admin</h6>
      @else

      <h6 class="m-0">{{$user->name}}</h6>
    @endif
          <small class="user-status text-muted">{{$user->user_type}}</small>

      @endforeach
          </div>
          </div>

        </div>
        </div>

        <div class="chat-history-body bg-body">
        <div id="chatWindow">
          <ul class="list-unstyled chat-history">
          {{-- admin li --}}

          @foreach ($chatData as $chat)
        @if($chat->sender_user_id == $id)
      <li class="chat-message chat-message-right">
      <div class="d-flex overflow-hidden">
      <div class="chat-message-wrapper flex-grow-1">
        <div class="chat-message-text">
        <p class="mb-0">{{$chat->message}}</p>
        </div>
        <div class="text-end text-muted mt-1">
        <i class="ti ti-checks ti-xs me-1 text-success"></i>
        <small>{{date('d-m-Y H:i:s', strtotime($chat->created_at))}}</small>
        </div>
      </div>
      <!-- <div class="user-avatar flex-shrink-0 ms-3">
        <div class="avatar avatar-sm">
        <img src="https://report.hgsfp.n-sip.gov.ng/asset/assets/img/avatars/1.png" alt="Avatar"
        class="rounded-circle" />
        </div>
      </div> -->
      </div>
      </li>
    @else
    {{-- user li --}}
    <li class="chat-message">
    <div class="d-flex overflow-hidden">
    <div class="user-avatar flex-shrink-0 me-3">
      <div class="avatar avatar-sm">
      <img src="asset/assets/img/avatars/2.png" alt="Avatar" class="rounded-circle" />
      </div>
    </div>
    <div class="chat-message-wrapper flex-grow-1">
      <div class="chat-message-text">
      <p class="mb-0">{{$chat->message}}</p>

      </div>

      <div class="text-muted mt-1">
      <small>{{date('d-m-Y H:i:s', strtotime($chat->created_at))}}</small>
      </div>
    </div>
    </div>
    </li>
  @endif
      @endforeach
          </ul>
        </div>

        </div>
        <!-- Chat message form -->
        <div class="chat-history-footer shadow-sm">
        <form class="form-send-message d-flex justify-content-between align-items-center" method="POST">


          <input class="form-control message-input border-0 me-3 shadow-none" placeholder="Type your message here"
          id="msg" name="msg" />
          <div class="message-actions d-flex align-items-center">
          <i class="speech-to-text ti ti-microphone ti-sm cursor-pointer"></i>
          <label for="attach-doc" class="form-label mb-0">
            <i class="ti ti-photo ti-sm cursor-pointer mx-3"></i>
            <input type="file" id="attach-doc" hidden />
          </label>
          <input type="hidden" name="senderId" id="senderId" value="{{$id}}" />
          <input type="hidden" name="reciverId" id="reciverId" value="{{$reciverId}}" />
          <input type="hidden" name="chatCount" id="chatCount" value="{{$chatCount}}" />
          <input type="hidden" name="_token" value="{{ csrf_token() }}">
          <button class="btn btn-primary d-flex send-msg-btn" id="submitBtn">
            <i class="ti ti-send me-md-1 me-0"></i>
            <span class="align-middle d-md-inline-block d-none">Send</span>
          </button>
          </div>
        </form>
        </div>

      </div>
      </div>
      <!-- /Chat History -->



      <div class="app-overlay"></div>
    </div>
    </div>
  </div>
  <!--/ Content -->
@endsection
@section('custom-js')
  <script>

    $(document).ready(function () {
    var reciverId = $('#reciverId').val();

    if (reciverId == "") {

      $('.chat-history-wrapper').hide()

    }

    });
    $('#submitBtn').click(function () {
    // alert("before");
    pageLoadSubmit();
    // alert("after");
    });

    function pageLoad() {
    // alert("in pageLoad function");

    $.ajaxSetup({
      headers: {
      'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
      }
    });

    var senderId = $('#senderId').val();
    var reciverId = $('#reciverId').val();

    $.ajax({
      url: "{{route('create-chat')}}",
      type: 'POST', // or GET
      data: { // data to be sent to the server
      "senderId": senderId,
      "reciverId": reciverId,
      "msg": "",
      "_token": '{{csrf_token()}}'
      },
      success: function (response) { // handle the response from the server
      // console.log(response);
      var userData = response['data'];

      var state_admins = response['state_admins'];
      var reciverData = response['ReciverData'];
      var chatData = response['chatData'];
      var id = response['id'];
      // console.log(chatData);
      var managerUserHtml = '<ul class="list-unstyled chat-contact-list mb-0" id="contact-list">' +
        '<li class="chat-contact-list-item chat-contact-list-item-title">' +
        '<h5 class="text-primary mb-0">Managers</h5>' +
        '</li>' +
        '<li class="chat-contact-list-item contact-list-item-0 d-none">' +
        '<h6 class="text-muted mb-0">No Managers Found</h6>' +
        '</li>';
      var adminUserHtml = '<ul class="list-unstyled chat-contact-list" id="chat-list">' +
        '<li class="chat-contact-list-item chat-list-item-0 d-none">' +
        '<h6 class="text-muted mb-0">No Chats Found</h6>' +
        '</li>';
      var i;
      for (i = 0; i < state_admins.length; ++i) {
        // for admin users 
        if (state_admins[i]['id'] != id) {
        var username;
        if (state_admins[i]['name'] == "Ariful Islam") {
          username = "Super Admin";
        } else {
          username = state_admins[i]['name'];
        }
        adminUserHtml += '' +

          '            <li class="chat-contact-list-item">' +
          '              <a class="d-flex align-items-center" data-id=' + state_admins[i]['id'] + '  href="?reciverId=' + state_admins[i]['id'] + '">' +
          '                <div class="flex-shrink-0 avatar avatar-online">' +
          '                  <img src="' + state_admins[i]['photo'] + '" alt="Avatar"' +
          '                    class="rounded-circle" />' +
          '                </div>' +
          '                <div class="chat-contact-info flex-grow-1 ms-2">' +
          '                  <h6 class="chat-contact-name text-truncate m-0">' + username + '</h6>' +
          '                  <p class="chat-contact-status text-muted text-truncate mb-0">' +
          '                   ' + state_admins[i]['user_type'] +
          '                  </p>' +
          '                </div>' +
          '                <small class="text-muted mb-auto">5 Minutes</small>' +
          '              </a>' +
          '            </li>' +



          '';
        }
      }
      for (i = 0; i < userData.length; ++i) {
        if (userData[i]['id'] != id) {
        managerUserHtml += '' +
          '            <li class="chat-contact-list-item">' +
          '              <a class="d-flex align-items-center" data-id=' + userData[i]['id'] + '  href="?reciverId=' + userData[i]['id'] + '">' +
          '                <div class="flex-shrink-0 avatar avatar-online">' +
          '                  <img src="' + userData[i]['photo'] + '" alt="Avatar"' +
          '                    class="rounded-circle" />' +
          '                </div>' +
          '                <div class="chat-contact-info flex-grow-1 ms-2">' +
          '                  <h6 class="chat-contact-name text-truncate m-0">' + userData[i]['name'] + '</h6>' +
          '                  <p class="chat-contact-status text-muted text-truncate mb-0">' +
          '                   ' + userData[i]['user_type'] +
          '                  </p>' +
          '                </div>' +

          '              </a>' +
          '            </li>' +



          '';
        }
      }
      var chatHtml = '<ul class="list-unstyled chat-history">';
      // loop for chats

      for (i = 0; i < chatData.length; ++i) {


        if (chatData[i]['sender_user_id'] == id) {
        chatHtml += '' +
          '<li class="chat-message chat-message-right">' +
          '<div class="d-flex overflow-hidden">' +
          '<div class="chat-message-wrapper flex-grow-1">' +
          '<div class="chat-message-text">' +
          '<p class="mb-0">' + chatData[i]['message'] + '</p>' +
          '</div>' +
          '<div class="text-end text-muted mt-1">' +
          '<i class="ti ti-checks ti-xs me-1 text-success"></i>' +
          '<small>' + chatData[i]['created_at'] + '</small>' +
          '</div>' +
          '</div>' +

          '</div>' +
          '</li>' +
          '';

        } else {
        chatHtml += '' +
          '<li class="chat-message">' +
          '<div class="d-flex overflow-hidden">' +
          '<div class="user-avatar flex-shrink-0 me-3">' +

          '</div>' +
          '<div class="chat-message-wrapper flex-grow-1">' +
          '<div class="chat-message-text">' +
          '<p class="mb-0">' + chatData[i]['message'] + '</p>' +

          '</div>' +

          '<div class="text-muted mt-1">' +
          '<small>' + chatData[i]['created_at'] + '</small>' +
          '</div>' +
          '</div>' +
          '</div>' +
          '</li>' +
          '';

        }

      }




      $('#adminUsersList').html(adminUserHtml + '</ul>');
      $('#usersList').html(managerUserHtml + '</ul>');
      $('#chatWindow').html(chatHtml + '</ul>');
      // playSound("https://report.hgsfp.n-sip.gov.ng/asset/assets/achive-sound-132273.mp3")

      },
      error: function (jqXHR, textStatus, errorThrown) { // handle any errors
      console.log(textStatus + ': ' + errorThrown);
      }
    });
    setTimeout(pageLoad, 15000);

    }

    function pageLoadSubmit() {
    // alert("in pageLoadSubmit function");
    $.ajaxSetup({
      headers: {
      'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
      }
    });

    var senderId = $('#senderId').val();
    var reciverId = $('#reciverId').val();
    var msg = $('#msg').val();
    $.ajax({
      url: "{{route('create-chat')}}",
      type: 'POST', // or GET
      data: { // data to be sent to the server
      "senderId": senderId,
      "reciverId": reciverId,
      "msg": msg,
      "_token": '{{csrf_token()}}'
      },
      success: function (response) { // handle the response from the server
      // console.log(response);
      var userData = response['data'];

      var state_admins = response['state_admins'];
      var reciverData = response['ReciverData'];
      var chatData = response['chatData'];
      console.log("chatData");
      console.log(state_admins);
      console.log("chatData");
      var id = response['id'];

      var managerUserHtml = '<ul class="list-unstyled chat-contact-list mb-0" id="contact-list">' +
        '<li class="chat-contact-list-item chat-contact-list-item-title">' +
        '<h5 class="text-primary mb-0">Managers</h5>' +
        '</li>' +
        '<li class="chat-contact-list-item contact-list-item-0 d-none">' +
        '<h6 class="text-muted mb-0">No Managers Found</h6>' +
        '</li>';
      var adminUserHtml = '<ul class="list-unstyled chat-contact-list" id="chat-list">' +
        '<li class="chat-contact-list-item chat-list-item-0 d-none">' +
        '<h6 class="text-muted mb-0">No Chats Found</h6>' +
        '</li>';
      var i;
      for (i = 0; i < state_admins.length; ++i) {
        // for admin users 
        if (state_admins[i]['id'] != id) {
        var username;
        if (state_admins[i]['name'] == "Ariful Islam") {
          username = "Super Admin";
        } else {
          username = state_admins[i]['name'];
        }
        adminUserHtml += '' +

          '            <li class="chat-contact-list-item">' +
          '              <a class="d-flex align-items-center" data-id=' + state_admins[i]['id'] + '  href="?reciverId=' + state_admins[i]['id'] + '">' +
          '                <div class="flex-shrink-0 avatar avatar-online">' +
          '                  <img src="' + state_admins[i]['photo'] + '" alt="Avatar"' +
          '                    class="rounded-circle" />' +
          '                </div>' +
          '                <div class="chat-contact-info flex-grow-1 ms-2">' +
          '                  <h6 class="chat-contact-name text-truncate m-0">' + username + '</h6>' +
          '                  <p class="chat-contact-status text-muted text-truncate mb-0">' +
          '                   ' + state_admins[i]['user_type'] +
          '                  </p>' +
          '                </div>' +
          '                <small class="text-muted mb-auto">5 Minutes</small>' +
          '              </a>' +
          '            </li>' +



          '';
        }
      }
      for (i = 0; i < userData.length; ++i) {
        if (userData[i]['id'] != id) {
        managerUserHtml += '' +
          '            <li class="chat-contact-list-item">' +
          '              <a class="d-flex align-items-center" data-id=' + userData[i]['id'] + '  href="?reciverId=' + userData[i]['id'] + '">' +
          '                <div class="flex-shrink-0 avatar avatar-online">' +
          '                  <img src="' + userData[i]['photo'] + '" alt="Avatar"' +
          '                    class="rounded-circle" />' +
          '                </div>' +
          '                <div class="chat-contact-info flex-grow-1 ms-2">' +
          '                  <h6 class="chat-contact-name text-truncate m-0">' + userData[i]['name'] + '</h6>' +
          '                  <p class="chat-contact-status text-muted text-truncate mb-0">' +
          '                   ' + userData[i]['user_type'] +
          '                  </p>' +
          '                </div>' +

          '              </a>' +
          '            </li>' +



          '';
        }
      }
      var chatHtml = '<ul class="list-unstyled chat-history">';
      // loop for chats

      for (i = 0; i < chatData.length; ++i) {
        // console.log(chatData[i]);
        if (chatData[i]['sender_user_id'] == id) {
        chatHtml += '' +
          '<li class="chat-message chat-message-right">' +
          '<div class="d-flex overflow-hidden">' +
          '<div class="chat-message-wrapper flex-grow-1">' +
          '<div class="chat-message-text">' +
          '<p class="mb-0">' + chatData[i]['message'] + '</p>' +
          '</div>' +
          '<div class="text-end text-muted mt-1">' +
          '<i class="ti ti-checks ti-xs me-1 text-success"></i>' +
          '<small>' + chatData[i]['created_at'] + '</small>' +
          '</div>' +
          '</div>' +
          '<div class="user-avatar flex-shrink-0 ms-3">' +
          '<div class="avatar avatar-sm">' +
          '<img src="asset/assets/img/avatars/1.png" alt="Avatar" class="rounded-circle" />' +
          '</div>' +
          '</div>' +
          '</div>' +
          '</li>' +
          '';

        } else {
        chatHtml += '' +
          '<li class="chat-message">' +
          '<div class="d-flex overflow-hidden">' +
          '<div class="user-avatar flex-shrink-0 me-3">' +
          '<div class="avatar avatar-sm">' +
          '<img src="asset/assets/img/avatars/2.png" alt="Avatar" class="rounded-circle" />' +
          '</div>' +
          '</div>' +
          '<div class="chat-message-wrapper flex-grow-1">' +
          '<div class="chat-message-text">' +
          '<p class="mb-0">' + chatData[i]['message'] + '</p>' +

          '</div>' +

          '<div class="text-muted mt-1">' +
          '<small>' + chatData[i]['created_at'] + '</small>' +
          '</div>' +
          '</div>' +
          '</div>' +
          '</li>' +
          '';

        }

      }




      $('#adminUsersList').html(adminUserHtml + '</ul>');
      $('#usersList').html(managerUserHtml + '</ul>');
      $('#chatWindow').html(chatHtml + '</ul>');
      playSound("https://report.hgsfp.n-sip.gov.ng/asset/assets/achive-sound-132273.mp3")

      },
      error: function (jqXHR, textStatus, errorThrown) { // handle any errors
      console.log(textStatus + ': ' + errorThrown);
      }
    });
    // setTimeout(pageLoad, 5000);

    }

    pageLoad();

    function playSound(url) {
    const audio = new Audio(url);
    audio.play();
    }



  </script>
@endsection