@extends('layouts.master')
@section('content')

    <div class="row">
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-0">Add  Cook</h6>
                        </div>
                        <div class="text-right">
                            @can('cook-list')
                                <a href="{{ route('cooks.index') }}" class="btn btn-success btn-sm mr-1"><i
                                        class="fas fa-align-justify mr-1"></i> Cook List</a>
                            @endcan
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    {!! Form::open(['route' => 'cooks.store', 'class' => 'form-horizontal', 'files' => true]) !!}

                    @include('cook.fields')

                <div class="row form-group">
                    <div class="col-md-4"></div>
                    <div class="col-md-8" style="margin-top: 10px;">
                        {{ Form::reset('Reset', array('class'=> 'btn btn-warning','style'=>'background:#ff9f43!important')) }}
                        
                        {{ Form::submit('Create', array('class' => 'btn btn-primary','style'=>'background:#7367f0!important')) }}
                    
               
                    </div>
                </div>

                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>


@endsection
