@extends('layouts.master')
@section('content')

    <div class="row">
        <div class="col-sm-12 col-md-12">
            <div class="card ">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="fs-17 font-weight-600 mb-0">List of Cooks</h6>
                        </div>
                        <div class="text-right">
                            @can('cook-create')
                                <a href="{{ route('cooks.create') }}" class="btn btn-success btn-sm mr-1"><i
                                        class="fas fa-plus mr-1"></i>Add Cook</a>
                            @endcan
                        </div>
                    </div>
                </div>
                <div class="card-body">

                    @can('upload-cook')
                        <div class="row mb-4">
                            <div class="col-md-3">
                                <a href="{{ asset('excel_demo/cooks_sample_file.xls') }}" class="btn btn-primary" download> <i
                                        class="fas fa-download"></i> Download Sample File</a>

                            </div>

                        </div>
                        {!! Form::open(['url' => 'import-cooks', 'method' => 'POST', 'class' => 'form-horizontal', 'files' => true]) !!}
                        <div class="row form-group">

                            {{ Form::label('', 'Upload Excel File') }}
                            <div class="col-md-4 input-group mb-3">
                                {{ Form::file('select_file', ['class' => 'btn btn-default', 'required']) }}
                                @if($errors->has('select_file'))
                                    <span class="help-block" style="display:block">
                                        <strong class="text-danger">{{ $errors->first('select_file') }}</strong>
                                    </span>
                                @endif
                                <div class="input-group-append">
                                    {{ Form::submit('Submit', ['class' => 'btn btn-primary', 'style' => 'color:rgb(255, 255, 255);background:#685dd8;']) }}
                                </div>
                            </div>

                        </div>
                        {!! Form::close() !!}
                    @endcan

                    <div class="table-responsive">

                        <table class="table display table-bordered table-striped table-hover custom-table" id="cooks">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Photo</th>
                                    <th>Name</th>
                                    <th>Gender</th>
                                    <th>Date Of Birth</th>
                                    <th>Phone</th>
                                    <th>BVN</th>
                                    <th>School</th>
                                    <th>Total Pupils</th>
                                    <th>Status</th>
                                    <th>Added By</th>
                                    @if(auth()->user()->can('cook-edit') || auth()->user()->can('cook-delete'))
                                        <th></th>
                                        <th></th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>


                            </tbody>
                        </table>
                    </div>
                    <!-- <div class="row text-center">
                            <div class="col-md-12 text-center">
                                {{ $cooks->links() }}
                            </div>
                        </div> -->
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="cooks_suspend">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Write suspend reason</h4>
                    <button type="button" class="close" data-dismiss="modal" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    {!! Form::open(['url' => 'suspend-request-confirm', 'class' => 'form-horizontal', 'files' => true]) !!}
                    {!! Form::hidden('type', 'cooks') !!}

                    <input type="hidden" name="cooks_aggregators_id" id="cooks_aggregators_id" />

                    <textarea name="reason" rows="5" placeholder="Why do you want to suspend his/her" class="form-control"
                        required></textarea>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal"
                        data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Confirm</button>
                    {!! Form::close() !!}
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

@endsection
@section('custom-js')
    <script>
        $(document).ready(function () {
            var url = $(location).attr('href');

            var urlVariables = url.split('/');
            var stateId = urlVariables['4'];
            $("#cooks").DataTable({

                processing: true,
                serverSide: true,
                order: [[0, "desc"]],
                // ajax: "{{ url('cooks-data') }}",

                "ajax": {
                    "url": "{{ url('cooks-data') }}",

                    "data": { state_id: stateId }
                },

                columns: [

                    { data: 'id' },


                    {
                        data: null,
                        defaultContent: '<img class="rounded-circle" src="backend/dist/img/avatar.png" alt="" width="65px" height="65px">'

                    },

                    {
                        data: null,
                        render: (data) => data.first_name + ' ' + data.middle_name + ' ' + data.last_name
                    },
                    { data: 'gender' },
                    { data: 'dob' },
                    { data: 'phone' },
                    { data: 'bvn' },

                    {
                        data: null,

                        render: (data) => data.school_name
                    },


                    { data: 'students' },
                    {

                        data: null,

                        render: (data) => data.status

                    },
                    { data: 'added_by' },
                    {
                        data: null,

                        render: (data, type, row) => {
                            return `<a href='cooks/${row.id}/edit'><i class="ti ti-edit ti-sm mx-2"></i></a>`;
                        }
                    },
                    {
                        data: null,

                        render: (data, type, row) => {
                            return `<a class="clickme" href="#" data-id="'${row.id}'" id="'${row.id}'"><i class="ti ti-trash ti-sm mx-2"></i></a>`;
                        }
                        // data :'<a class="clickme" href="#" data-id="' + row.id + '" id="' + row.id + '">' + row.id + '</a>'
                    }

                ]
            });
            $(document).on('click', '.clickme', function (e) {
                e.preventDefault();
                var id = $(this).data('id');
                var result = id.substring(1, id.length - 1);
                $('#cooks_suspend').modal('show');
                // $('#cooks_suspend').find('#cooks_aggregators_id').val(id);
                $('#cooks_suspend').find('#cooks_aggregators_id').val(result);


                console.log(result);
            })


        });

    </script>
@endsection