<!-- Created by Ariful Islam at 06/27/2020 - 3:12 AM -->
@extends('layouts.master')
@section('custom-css')
    <style>
        .modal-overlay {
            background: #111111 !important;
        }

        .layout-navbar-full .content-wrapper {
            width: 100% !important;
        }

        .scrollable {
            overflow-y: auto;
            max-height: 300px;
        }
    </style>
@endsection
@section('content')

    <!-- Content -->

    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">
            <div class="col-xl-4 mb-4 col-lg-5 col-12">
                <div class="card">
                    <div class="d-flex align-items-end row">
                        <div class="col-7">
                            <div class="card-body text-nowrap">
                                <h5 class="card-title mb-0">Welcome {{ Auth::user()->name }}! 🎉</h5>

                            </div>
                        </div>
                        <div class="col-5 text-center text-sm-left">
                            <div class="card-body pb-0 px-0 px-md-4">
                                <img src="asset/assets/img/illustrations/card-advance-sale.png" height="140"
                                    alt="view sales">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-8 mb-4 col-lg-7 col-12">
                <div class="card h-100">
                    <div class="card-header">
                        <div class="d-flex justify-content-between mb-3">
                            <h5 class="card-title mb-0">Statistics</h5>
                            <small class="text-muted">Updated 1 month ago</small>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">
                            <div class="col-md-3 col-6">
                                <div class="d-flex align-items-center">
                                    <div class="badge rounded-pill bg-label-primary me-3 p-2">
                                        <i class="ti ti-users ti-sm"></i>
                                    </div>
                                    <div class="card-info">
                                        <!--<h5 class="mb-0">{{number_format($pupils)}}</h5>-->
                                        <h5 class="mb-0">10,049,975</h5>

                                        <small>Total Pupils</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 col-6">
                                <div class="d-flex align-items-center">
                                    <div class="badge rounded-pill bg-label-info me-3 p-2">
                                        <!-- <i class="ti ti-users ti-sm"></i> -->
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                            class="icon icon-tabler icon-tabler-backpack" width="24" height="24"
                                            viewBox="0 0 24 24" stroke-width="1.75" stroke="currentColor" fill="none"
                                            stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <path
                                                d="M5 18v-6a6 6 0 0 1 6 -6h2a6 6 0 0 1 6 6v6a3 3 0 0 1 -3 3h-8a3 3 0 0 1 -3 -3z">
                                            </path>
                                            <path d="M10 6v-1a2 2 0 1 1 4 0v1"></path>
                                            <path d="M9 21v-4a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v4"></path>
                                            <path d="M11 10h2"></path>
                                        </svg>
                                    </div>
                                    <div class="card-info">
                                        <!--<h5 class="mb-0">{{number_format($total_schools)}}</h5>-->
                                        <h5 class="mb-0">57,517</h5>
                                        <small>Total Schools</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 col-6">
                                <div class="d-flex align-items-center">
                                    <div class="badge rounded-pill  bg-label-primary me-3 p-2">
                                        <!-- <i class="ti ti-shopping-cart ti-sm"></i> -->
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                            class="icon icon-tabler icon-tabler-chef-hat" width="24" height="24"
                                            viewBox="0 0 24 24" stroke-width="1.75" stroke="currentColor" fill="none"
                                            stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <path
                                                d="M12 3c1.918 0 3.52 1.35 3.91 3.151a4 4 0 0 1 2.09 7.723l0 7.126h-12v-7.126a4 4 0 1 1 2.092 -7.723a4 4 0 0 1 3.908 -3.151z">
                                            </path>
                                            <path d="M6.161 17.009l11.839 -.009"></path>
                                        </svg>
                                    </div>
                                    <div class="card-info">
                                        <!--<h5 class="mb-0">{{number_format($total_cooks)}}</h5>-->
                                        <h5 class="mb-0">126,927</h5>
                                        <small>Total Cooks</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 col-6">
                                <div class="d-flex align-items-center">
                                    <div class="badge rounded-pill bg-label-success me-3 p-2">
                                        <!-- <i class="ti ti-currency-dollar ti-sm"></i> -->
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                            class="icon icon-tabler icon-tabler-users-group" width="24" height="24"
                                            viewBox="0 0 24 24" stroke-width="1.75" stroke="currentColor" fill="none"
                                            stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <path d="M10 13a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"></path>
                                            <path d="M8 21v-1a2 2 0 0 1 2 -2h4a2 2 0 0 1 2 2v1"></path>
                                            <path d="M15 5a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"></path>
                                            <path d="M17 10h2a2 2 0 0 1 2 2v1"></path>
                                            <path d="M5 5a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"></path>
                                            <path d="M3 13v-1a2 2 0 0 1 2 -2h2"></path>
                                        </svg>
                                    </div>
                                    <div class="card-info">
                                        @if ($total_aggregators >= 1000)
                                            <!--<h5 class="mb-0">{{number_format($total_aggregator)}}</h5>-->

                                            <h5 class="mb-0">{{ number_format($total_aggregators)}}</h5>
                                        @else
                                            <h5 class="mb-0">117</h5>
                                        @endif
                                        <small>Total Aggregators</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-4 col-6 mb-4">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5 class="card-title mb-0">Report</h5>
                        <small class="text-muted">2025</small>
                    </div>
                    <div id="salesLastYear"></div>
                    <div class="card-body pt-0">
                        <div class="d-flex justify-content-between align-items-center mt-3 gap-3">

                        </div>
                    </div>
                </div>
            </div>

            <!-- Sessions Last month -->
            <div class="col-xl-3 col-md-4 col-6 mb-4">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5 class="card-title mb-0">Sessions</h5>

                    </div>
                    <div class="card-body">
                        <div id="sessionsLastMonth"></div>
                        <div class="d-flex justify-content-between align-items-center mt-3 gap-3">
                            <h4 class="mb-0">45.1k</h4>
                            <small class="text-success">+12.6%</small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Profit -->
            <div class="col-xl-3 col-md-4 col-6 mb-4">
                <div class="card">
                    <div class="card-body">
                        <div class="badge p-2 bg-label-success mb-2 rounded">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-chef-hat" width="24"
                                height="24" viewBox="0 0 24 24" stroke-width="1.75" stroke="currentColor" fill="none"
                                stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path
                                    d="M12 3c1.918 0 3.52 1.35 3.91 3.151a4 4 0 0 1 2.09 7.723l0 7.126h-12v-7.126a4 4 0 1 1 2.092 -7.723a4 4 0 0 1 3.908 -3.151z">
                                </path>
                                <path d="M6.161 17.009l11.839 -.009"></path>
                            </svg>
                        </div>
                        <h5 class="card-title mb-1 pt-2">Active Cooks</h5>
                        <small class="text-muted">Total</small>
                        <p class="mb-2 mt-1">{{number_format($total_active_cooks)}}</p>

                    </div>
                </div>
            </div>

            <!-- Total Sales -->
            <div class="col-xl-3 col-md-4 col-6 mb-4">
                <div class="card">
                    <div class="card-body">
                        <div class="badge p-2 bg-label-danger mb-2 rounded">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-chef-hat" width="24"
                                height="24" viewBox="0 0 24 24" stroke-width="1.75" stroke="currentColor" fill="none"
                                stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path
                                    d="M12 3c1.918 0 3.52 1.35 3.91 3.151a4 4 0 0 1 2.09 7.723l0 7.126h-12v-7.126a4 4 0 1 1 2.092 -7.723a4 4 0 0 1 3.908 -3.151z">
                                </path>
                                <path d="M6.161 17.009l11.839 -.009"></path>
                            </svg>
                        </div>
                        <h5 class="card-title mb-1 pt-2">Suspended Cooks</h5>
                        <small class="text-muted">Total</small>
                        <p class="mb-2 mt-1">{{ number_format($total_suspended_cooks) }}</p>

                    </div>
                </div>
            </div>


            <div class="col-xl-4 col-md-6 mb-4 ">
                <div class="card h-100">
                    <div class="card-header d-flex justify-content-between">
                        <div class="card-title m-0 me-2">
                            <h5 class="m-0 me-2">Puplis</h5>
                            <small class="text-muted">{{$listing_title}} Pupils Summary</small>
                        </div>

                    </div>
                    <div class="card-body" style="overflow-y: auto; max-height: 350px;">
                        <ul class="p-0 m-0">
                            @foreach($state_pupiles as $states)
                                <li class="d-flex mb-4 pb-1 align-items-center">

                                    <div class="d-flex w-100 align-items-center gap-2">
                                        <div class="d-flex justify-content-between flex-grow-1 flex-wrap">
                                            <div>
                                                <h6 class="mb-0">{{$states->state_name}}</h6>
                                            </div>

                                            <div class="user-progress d-flex align-items-center gap-2">
                                                @if($states->user_count)
                                                    @if ($states->user_count >= 1000)
                                                        <h6 class="mb-0">{{number_format($states->user_count)}}</h6>

                                                    @else
                                                        <h6 class="mb-0">{{$states->user_count}}</h6>
                                                    @endif

                                                @else
                                                    <h6 class="mb-0">0</h6>
                                                @endif
                                            </div>
                                        </div>

                                    </div>
                                </li>
                            @endforeach

                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-xl-4 col-md-6 mb-4 ">
                <div class="card h-100">
                    <div class="card-header d-flex justify-content-between">
                        <div class="card-title m-0 me-2">
                            <h5 class="m-0 me-2">Active Cooks</h5>
                            <small class="text-muted">{{$listing_title}} Active Cooks</small>
                        </div>

                    </div>
                    <div class="card-body" style="overflow-y: auto; max-height: 350px;">
                        <ul class="p-0 m-0">
                            @foreach($state_wise_active_cooks as $cooks)
                                <li class="d-flex mb-4 pb-1 align-items-center">

                                    <div class="d-flex w-100 align-items-center gap-2">
                                        <div class="d-flex justify-content-between flex-grow-1 flex-wrap">
                                            <div>
                                                <h6 class="mb-0">{{$cooks->state_name}}</h6>
                                            </div>

                                            <div class="user-progress d-flex align-items-center gap-2">
                                                <h6 class="mb-0">{{number_format($cooks->user_count)}}</h6>
                                            </div>
                                        </div>

                                    </div>
                                </li>
                            @endforeach

                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6 mb-4 ">
                <div class="card h-100">
                    <div class="card-header d-flex justify-content-between">
                        <div class="card-title m-0 me-2">
                            <h5 class="m-0 me-2">Suspended Cooks</h5>
                            <small class="text-muted">{{$listing_title}} Suspended Cooks</small>
                        </div>

                    </div>
                    <div class="card-body" style="overflow-y: auto; max-height: 350px;">
                        <ul class="p-0 m-0">
                            @foreach($state_wise_in_active_cooks as $cooks)
                                <li class="d-flex mb-4 pb-1 align-items-center">

                                    <div class="d-flex w-100 align-items-center gap-2">
                                        <div class="d-flex justify-content-between flex-grow-1 flex-wrap">
                                            <div>
                                                <h6 class="mb-0">{{$cooks->state_name}}</h6>
                                            </div>

                                            <div class="user-progress d-flex align-items-center gap-2">
                                                <h6 class="mb-0">{{$cooks->user_count}}</h6>
                                            </div>
                                        </div>

                                    </div>
                                </li>
                            @endforeach

                        </ul>
                    </div>
                </div>
            </div>


        </div>
    </div>
    <!--/ Content -->
@endsection
@section('custom-js')
    <script>
        $(document).ready(function () {
            $("#userModal").modal('show');
        });
    </script>
@endsection