 <?php
  use App\State;
  $State = State::all();
  $StateUnique = $State->unique('id');
?>
 <!-- Navbar -->

      <nav class="layout-navbar navbar navbar-expand-xl align-items-center bg-navbar-theme" id="layout-navbar">
        <div class="container-xxl">
          <div class="navbar-brand app-brand demo d-none d-xl-flex py-0 me-4">
            <a href="{{ url('/home') }}"  class="app-brand-link gap-2">
              <span class="app-brand-logo">
                <img src="{{ asset('backend/dist/img/logo/fav.png') }}" alt="Logo" class="h-auto rounded-circle" style="opacity: .8;height: 48px !important;">
              </span>
              <span class="app-brand-text demo menu-text fw-bold">NHGSFP</span>
              
            </a>

            <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto d-xl-none">
              <i class="ti ti-x ti-sm align-middle"></i>
            </a>
          </div>

          <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
            <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
              <i class="ti ti-menu-2 ti-sm"></i>
            </a>
          </div>

          <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
            <ul class="navbar-nav flex-row align-items-center ms-auto">
              @can('notification')
              <li class="nav-item dropdown-notificationsnotifications navbar-dropdown dropdown me-3 me-xl-1">
                <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown"
                  data-bs-auto-close="outside" aria-expanded="false">
                  <i class="ti ti-mail ti-md"></i>
                  <?php
                    if(auth()->user()->user_type == "Admin"){
                        $count = \App\Withdraw::all()->where('notification','=',0)->count();
                        $notifications = \App\Withdraw::where('status','=','Pending')->get();
                    }else{
                        $count = \App\Withdraw::all()->where('manager_id','=',auth()->id())->where('notification','=',2)->count();
                        $notifications = \App\Withdraw::where('manager_id','=',auth()->id())->where('notification','=',2)->orderBy('id', 'DESC')->get();
                    }
                  ?>
                  <span class="badge bg-danger rounded-pill badge-notifications">{{$count}}</span>
                </a>
                <ul class="dropdown-menu dropdown-menu-end py-0">
                  <li class="dropdown-menu-header border-bottom">
                    <div class="dropdown-header d-flex align-items-center py-3">
                      
                      <a href="javascript:void(0)" class="dropdown-notifications-all text-body" data-bs-toggle="tooltip"
                        data-bs-placement="top" title="Mark all as read"><i class="ti ti-mail-opened fs-4"></i></a>
                    </div>
                  </li>

                  <li class="dropdown-notifications-list scrollable-container">
                    <ul class="list-group list-group-flush">
                      @foreach($notifications as $notification)
                      <?php
                          if(auth()->user()->user_type == "Admin"){
                              $user = \App\User::find($notification->manager_id);
                              $message = "Your have payment request from ".$user->state." state";
                          }else{
                              $message = "Admin ".$notification->status." your payment";
                          }

                      ?>
                      <li class="list-group-item list-group-item-action dropdown-notifications-item">
                        <div class="d-flex">
                          <div class="flex-shrink-0 me-3">
                            
                          </div>
                          <div class="flex-grow-1">
                            <a href="{{url('withdraw')}}" class="dropdown-item">
                            <h6 class="mb-1">{{ $message }}</h6>
                            </a>
                            
                            
                          </div>
                          
                        </div>
                      </li>
                      @endforeach
                      
                    </ul>
                  </li>
                  
                </ul>
              </li>
              @endcan

              @can('notification')
              <!-- Notification -->

              <li class="nav-item dropdown-notificationsnotifications navbar-dropdown dropdown me-3 me-xl-1">
                <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown"
                  data-bs-auto-close="outside" aria-expanded="false">
                  <i class="ti ti-bell ti-md"></i>
                  <span class="badge bg-danger rounded-pill badge-notifications">{{\Illuminate\Support\Facades\DB::table('notifications')->where('notifiable_id','=',auth()->id())->where('read_at','=',null)->count()}}</span>
                </a>
                <ul class="dropdown-menu dropdown-menu-end py-0">
                  <li class="dropdown-menu-header border-bottom">
                    <div class="dropdown-header d-flex align-items-center py-3">
                      <h5 class="text-body mb-0 me-auto">Notification</h5>
                      <a href="javascript:void(0)" class="dropdown-notifications-all text-body" data-bs-toggle="tooltip"
                        data-bs-placement="top" title="Mark all as read"><i class="ti ti-mail-opened fs-4"></i></a>
                    </div>
                  </li>
                  <li class="dropdown-notifications-list scrollable-container">
                    <ul class="list-group list-group-flush">
                      @foreach(\Illuminate\Support\Facades\Auth::user()->notifications as $notification)
                      <li class="list-group-item list-group-item-action dropdown-notifications-item">
                        <?php
                        // echo $notification->type;
                        if($notification->type == "App\Notifications\NewAggregatorsNotification"){
                            $url = "aggregators";
                        }elseif($notification->type == "App\Notifications\NewSchoolNotification"){
                            $url = "school";
                        }elseif($notification->type == "App\Notifications\NewCooksNotification"){
                            $url = "cooks";
                        }elseif($notification->type == "App\Notifications\NewFeedingNotification"){
                            $url = "feeding-report-request";
                        
                        }elseif($notification->type == "App\Notifications\NewWithdrawNotification"){
                            $url = "withdraw";
                        }
                        else{
                            $url = "#";
                        }
                      ?>
                        <div class="d-flex">
                          
                          <div class="flex-grow-1">
                            <a href="{{url($url)}}">
                            <p class="mb-0"> {{ $notification->data['message']}}</p>
                            <small class="text-muted">{{ \Carbon\Carbon::parse($notification->created_at)->diffForHumans() }}</small>
                            <a>
                          </div>
                          <div class="flex-shrink-0 dropdown-notifications-actions">
                            <a href="javascript:void(0)" class="dropdown-notifications-read"><span
                                class="badge badge-dot"></span></a>
                            <a href="javascript:void(0)" class="dropdown-notifications-archive"><span
                                class="ti ti-x"></span></a>
                          </div>
                        </div>
                      </li>
                      @endforeach
                    </ul>
                  </li>
                  <li class="dropdown-menu-footer border-top">
                    <a href="{{ url('notifications') }}"
                      class="dropdown-item d-flex justify-content-center text-primary p-2 h-px-40 mb-1 align-items-center">
                      View all notifications
                    </a>
                  </li>
                </ul>
              </li>
              <!--/ Notification -->
              @endcan
              <!-- Search -->
              <!--<li class="nav-item">-->
              <!--  <a class="nav-link search-toggler" title="Media" href="#" role="button" data-toggle="modal" data-target="#mediaModal">-->
              <!--    <i class="ti ti-camera ti-md"></i>-->
              <!--  </a>-->
              <!--</li>-->
              <!-- /Search -->

              <!-- Style Switcher -->
              
              <li class="nav-item">
                <a class="nav-link style-switcher-toggle hide-arrow" href="javascript:void(0);">
                  <i class="ti ti-md"></i>
                </a>
              </li>
              <!--/ Style Switcher -->
              

              <!-- User -->
              <li class="nav-item navbar-dropdown dropdown-user dropdown">
                <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                  <div class="avatar avatar-online">
                    <img src="{{ Auth::user()->photo }}" alt class="h-auto rounded-circle" />
                  </div>
                </a>
                <ul class="dropdown-menu dropdown-menu-end">
                  <li>
                    <a class="dropdown-item" href="/my-profile">
                      <div class="d-flex">
                        <div class="flex-shrink-0 me-3">
                          <div class="avatar avatar-online">
                            <img src="{{ Auth::user()->photo }}" alt class="h-auto rounded-circle" />
                          </div>
                        </div>
                        <div class="flex-grow-1">
                          <span class="fw-semibold d-block">{{ Auth::user()->name }}</span>
                          <small class="text-muted">Admin</small>
                        </div>
                      </div>
                    </a>
                  </li>
                  <li>
                    <div class="dropdown-divider"></div>
                  </li>
                  <li>
                    <a class="dropdown-item" href="/my-profile">
                      <i class="ti ti-user-check me-2 ti-sm"></i>
                      <span class="align-middle">My Profile</span>
                    </a>
                  </li>
                  
                  <li>
                    <a role="button" title="Logout"  href="{{ route('logout') }}" class="nav-link"  onclick="event.preventDefault();document.getElementById('logout-form').submit();">
                      <i class="ti ti-logout me-2 ti-sm"></i>
                      <span class="align-middle">Log Out</span>
                      <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                          @csrf
                          {{-- @method('PUT') --}}
                      </form>
                    </a>

                  </li>
                </ul>
              </li>
              <!--/ User -->
            </ul>
          </div>

          
        </div>
      </nav>

      <!-- / Navbar -->
        <!-- Modal -->
<div class="modal fade" id="mediaModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add Media Item</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="alert" id="message" style="display: none"></div>
        <form method="post" id="upload_form" enctype="multipart/form-data">
          {{ csrf_field() }}
        <div class="row form-group">
          <div class="col-md-2">{{ Form::label('title', 'Title') }}</div>
          <div class="col-md-6">{{ Form::text('title','', array('class'=>'form-control')) }}</div>
        </div>

        <div class="row form-group">
          <div class="col-md-2">{{ Form::label('file', 'File') }}</div>
            <div class="col-md-6">{{ Form::file('file', array('class'=>'btn btn-default btn-file')) }}
            
               @if($errors->has('file'))
               <span class="help-block">
              <strong>{{ $errors->first('file') }}</strong>
             </span>
           @endif
          </div> 
        </div>
          <table class="table">
            <tbody>
          <tr>
            <td width="40%" align="right"></td>
            <td width="30"><span class="text-muted">jpeg,jpg,png,ico,JPG,pdf</span></td>
            <td width="20%" align="left"></td>
           </tr>
          </tbody>
          </table>
     

         <div class="row form-group">
           <div class="col-md-4"></div>
           <div class="col-md-6">
            <input type="reset" class="btn btn-warning" value="Clear">
            <input type="submit" name="upload" id="upload" class="btn btn-primary" value="Upload">
            </div>       
          </div>
        </form>
        <br>
        <span id="uploaded_image_url"></span>
        <span id="uploaded_image"></span>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        {{-- <button type="button" class="btn btn-primary">Save changes</button> --}}
      </div>
    </div>
  </div>
</div>
<!-- / Navbar -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Content wrapper -->
                <div class="content-wrapper">