<?php
use App\State;

$State = State::all();
$StateUnique = $State->unique('id');
?>  <!-- Main Sidebar Container -->
<style>
    .user-panel img {
        width: 2.1rem;
        height: 2.1rem;
    }
</style>
<aside class="main-sidebar sidebar-dark-primary elevation-4 fixed">
    <!-- Brand Logo -->
    <a href="{{ url('/home')}}" class="brand-link">
        <img src="{{ asset('backend/dist/img/logo/fav.png') }}" alt="Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
        <span class="brand-text font-weight-light">NSFRS</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <!-- Sidebar user panel (optional) -->
        <div class="user-panel mt-3 pb-3 mb-3 d-flex">
            <div class="image">
                <img src="{{ Auth::user()->photo }}" class="img-circle elevation-2" alt="User Image">
            </div>
            <div class="info">
                <a href="javascript:void()" class="d-block" data-toggle="modal" data-target="#profile_{{ Auth::user()->id }}">{{ Auth::user()->name }}</a>
            </div>
        </div>

        <!-- SidebarSearch Form -->
    {{-- <div class="form-inline">
      <div class="input-group" data-widget="sidebar-search">
        <input class="form-control form-control-sidebar" type="search" placeholder="Search" aria-label="Search">
        <div class="input-group-append">
          <button class="btn btn-sidebar">
            <i class="fas fa-search fa-fw"></i>
          </button>
        </div>
      </div>
    </div> --}}

    <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                <!-- Add icons to the links using the .nav-icon class
                     with font-awesome or any other icon font library -->
                <li class="nav-item">
                    <a href="{{ url('/home') }}" class="nav-link">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>
                            Dashboard
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ url('/my-profile') }}" class="nav-link">
                        <i class="nav-icon fas fa-user-circle"></i>
                        <p>
                            My Profile
                        </p>
                    </a>
                </li>
                {{-- state admin list --}}
                {{-- @hasrole('Admin')
                 <li class="nav-item">
                   @foreach ($user_roles as $role)
                       {{ $role->name }}
                   @endforeach
                  <a href="{{ url('/state-admin') }}" class="nav-link">
                    <i class="nav-icon fas fa-user"></i>
                    <p>
                      State Admin
                    </p>
                  </a>
                </li>
                @endhasrole --}}
                {{-- state admin list end --}}


                @hasrole('Admin')
                <li class="nav-item">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fas fa-user"></i>
                        <p>
                            Role Users
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        @foreach ($user_roles as $role)
                            <li class="nav-item">
                                <a href="{{ url('user-role').'/'.$role->name }}" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>{{ $role->name }}</p>
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </li>
                @endhasrole

                <li class="nav-header">Feature</li>

                @can('school-manage')
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fas fa-university"></i>
                            <p>
                                School
                                <i class="fas fa-angle-left right"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            @can('school-create')
                                <li class="nav-item">
                                    <a href="{{ route('school.create') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Add new School</p>
                                    </a>
                                </li>
                            @endcan
                            @can('school-list')
                                <li class="nav-item">
                                    <a href="{{ route('school.index') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>School List</p>
                                    </a>
                                </li>
                            @endcan
                        </ul>
                    </li>
                @endcan

                @can('state-wise-school')
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fas fa-university"></i>
                            <p>
                                State School
                                <i class="fas fa-angle-left right"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">

                            @foreach ($StateUnique as $school)
                                <li class="nav-item">
                                    <a href="{{ url('state-wise-school'.'/'.$school->id) }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>{{ \App\State::get_state($school->id) }}</p>
                                    </a>
                                </li>
                        @endforeach


                        <!-- @foreach ($all_school as $school)
                            <li class="nav-item">
                              <a href="{{ url('state-wise-school'.'/'.$school->state) }}" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>{{ \App\State::get_state($school->state) }}</p>
                </a>
              </li>
              @endforeach -->

                        </ul>
                    </li>
                @endcan

                {{-- <li class="nav-item">
                  <a href="#" class="nav-link">
                    <i class="nav-icon fas fa-user-tie"></i>
                    <p>
                       Program Manager
                      <i class="fas fa-angle-left right"></i>
                    </p>
                  </a>
                  <ul class="nav nav-treeview">
                    <li class="nav-item">
                      <a href="{{ route('program-manager.create') }}" class="nav-link">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Add NewManager</p>
                      </a>
                    </li>
                    <li class="nav-item">
                      <a href="{{ route('program-manager.index') }}" class="nav-link">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Manager List</p>
                      </a>
                    </li>
                  </ul>
                </li> --}}

                {{-- cooks section start --}}
                @can('cook-manage')
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-utensils nav-icon"></i>
                            <p>
                                Cooks
                                <i class="fas fa-angle-left right"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            @can('cook-create')
                                <li class="nav-item">
                                    <a href="{{ route('cooks.create') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Add New Cook</p>
                                    </a>
                                </li>
                            @endcan
                            @can('cook-list')
                                <li class="nav-item">
                                    <a href="{{ route('cooks.index') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Cook List</p>
                                    </a>
                                </li>
                            @endcan
                        </ul>
                    </li>
                @endcan

                @can('state-wise-cook')
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-utensils nav-icon"></i>
                            <p>
                                State Cooks
                                <i class="fas fa-angle-left right"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">

                            @foreach ($StateUnique as $cook)
                                <li class="nav-item">
                                    <a href="{{ url('state-wise-cook'.'/'.$cook->id) }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>{{ \App\State::get_state($cook->id) }}</p>
                                    </a>
                                </li>
                        @endforeach

                        <!-- @foreach ($all_cook as $cook)
                            <li class="nav-item">
                              <a href="{{ url('state-wise-cook'.'/'.$cook->state) }}" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>{{ \App\State::get_state($cook->state) }}</p>
                </a>
              </li>
              @endforeach -->

                        </ul>
                    </li>
                @endcan
                {{-- cooks section end --}}

                {{-- aggregator section start --}}
                @can('aggregator-manage')
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-users nav-icon"></i>
                            <p>
                                Aggregators
                                <i class="fas fa-angle-left right"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            @can('aggregator-create')
                                <li class="nav-item">
                                    <a href="{{ route('aggregators.create') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Add New Aggregator</p>
                                    </a>
                                </li>
                            @endcan
                            @can('aggregator-list')
                                <li class="nav-item">
                                    <a href="{{ route('aggregators.index') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Aggregator List</p>
                                    </a>
                                </li>
                            @endcan
                        </ul>
                    </li>
                @endcan
                @can('state-wise-aggregator')
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-users nav-icon"></i>
                            <p>
                                State Aggregators
                                <i class="fas fa-angle-left right"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">

                            @foreach ($StateUnique as $aggregators)
                                <li class="nav-item">
                                    <a href="{{ url('state-wise-aggregator'.'/'.$aggregators->id) }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>{{ \App\State::get_state($aggregators->id) }}</p>
                                    </a>
                                </li>
                        @endforeach

                        <!-- @foreach ($all_aggregator as $aggregator)
                            <li class="nav-item">
                              <a href="{{ url('state-wise-aggregator'.'/'.$aggregator->state) }}" class="nav-link">
                    <i class="far fa-circle nav-icon"></i>
                    <p>{{ \App\State::get_state($aggregator->state) }}</p>
                  </a>
                </li>
                @endforeach -->

                        </ul>
                    </li>
                @endcan
                {{-- aggregator section end --}}

                {{-- feeding section start --}}
                @can('feeding-manage')
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-pizza-slice nav-icon"></i>
                            <p>
                                Pupils
                                <i class="fas fa-angle-left right"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            @can('feeding-create')
                                <li class="nav-item">
                                    <a href="{{ route('feedings.create') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Add New Pupils</p>
                                    </a>
                                </li>
                            @endcan
                            @can('feeding-list')
                                <li class="nav-item">
                                    <a href="{{ route('feedings.index') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Pupils List</p>
                                    </a>
                                </li>
                            @endcan
                            @can('feeding-list')
                                <li class="nav-item">
                                    <a href="{{ route('feedings.request_list') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Payment Request List</p>
                                    </a>
                                </li>
                            @endcan
                        </ul>
                    </li>
                @endcan

                @can('state-wise-feeding')
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-pizza-slice nav-icon"></i>
                            <p>
                                State Pupils
                                <i class="fas fa-angle-left right"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                        <!-- @foreach ($all_feeding as $feeding)
                            <li class="nav-item">
                             <a href="{{ url('state-wise-feeding'.'/'.$feeding->state) }}" class="nav-link">
                <i class="far fa-circle nav-icon"></i>
                <p>{{ \App\State::get_state($feeding->state) }}</p>
              </a>
            </li>
             @endforeach -->


                        </ul>
                    </li>
                @endcan
                {{-- feeding section end --}}

                {{-- report section start --}}
                @can('report')
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-chart-line nav-icon"></i>
                            <p>
                                Reports
                                <i class="fas fa-angle-left right"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="{{ url('report-form') }}" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Make Report</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                @endcan
                {{-- report section end --}}

                {{-- blog/post section  --}}
                @can('post-manage')
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="nav-icon far fa-file-image"></i>
                            <p>
                                Blog/Post
                                <i class="fas fa-angle-left right"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            @can('post-create')
                                <li class="nav-item">
                                    <a href="{{ route('posts.create') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Add New Blog</p>
                                    </a>
                                </li>
                            @endcan
                            @can('post-list')
                                <li class="nav-item">
                                    <a href="{{ route('posts.index') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Blog List</p>
                                    </a>
                                </li>
                            @endcan
                        </ul>
                    </li>
                @endcan

                <li class="nav-item">
                    <a href="{{ url('/suspend-requests') }}" class="nav-link">
                        <i class="nav-icon fas fa-user-friends text-danger"></i>
                        <p class="text">Suspend Requests</p>
                    </a>
                </li>

                @can('activity-log')
                    <li class="nav-item">
                        <a href="{{ url('/activity-logs') }}" class="nav-link">
                            <i class="nav-icon fas fa-history text-info"></i>
                            <p class="text">Activity Logs</p>
                        </a>
                    </li>
                @endcan

                @hasrole('Admin')
                <li class="nav-header">Role Permission</li>
                <li class="nav-item">
                    <a href="{{ url('/users') }}" class="nav-link">
                        <i class="nav-icon fas fa-user-friends text-danger"></i>
                        <p class="text">Users</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ url('/roles') }}" class="nav-link">
                        <i class="nav-icon fas fa-user-lock text-warning"></i>
                        <p>Role</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ url('/permissions')}}" class="nav-link">
                        <i class="nav-icon fa fa-lock text-info"></i>
                        <p>Permission</p>
                    </a>
                </li>
                @endhasrole

                <li class="nav-item">
                    <a href="{{ url('/media') }}" class="nav-link">
                        <i class="nav-icon fas fa-camera"></i>
                        <p>
                            Media
                        </p>
                    </a>
                </li>
            </ul>
        </nav>
        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>


{{-- admin info modal start --}}
<div class="modal fade" id="profile_{{ Auth::user()->id }}">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">{{ Auth::user()->name }}</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p><b>Name: {{ Auth::user()->name }}</b></p>
                <p><b>Email: {{ Auth::user()->email }}</b></p>
            </div>
            <div class="modal-footer justify-content-between">
                {{-- <button type="button" class="btn btn-danger">Save changes</button> --}}
                <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
{{-- admin info modal end --}}
