@extends('layouts.master') @section('title', 'Payment detail')

@section('content')
	<div class="row">
		@if($show == 0)
				<div class="col-md-12 col-lg-12">
					<div class="card">
						<div class="card-header py-2">
							<div class="d-flex justify-content-between align-items-center">
								<div>
									<h6 class="mb-0">Today Payment</h6>
								</div>
							</div>
						</div>
						<div class="mainHolder">

							<div class="card-body">
								@if($edit == 1)
									<form method="post" action="{{route('payment.index')}}">
								@else
										<form method="post" action="{{route('payment.update', $payment[0]->id)}}">
									@method('PUT') @endif @csrf
										<div class="row">
											<div class="col-md-4 mb-2">
												<label>State Name</label> <input value="{{$state->name}}" type="text" readonly
													class="form-control" placeholder="State">
											</div>
											<div class="col-md-4 mb-2">
												<label>Total Cooks</label> <input value="{{$total_cook}}" type="text"
													name="total_cook" readonly class="form-control" placeholder="Total Cooks">
											</div>
											<div class="col-md-4 mb-2">
												<label>Total Pupils</label> <input value="{{$total_pupils}}" type="text"
													name="total_pupils" readonly class="form-control" placeholder="Total Pupils">
											</div>

											<div class="col-md-4 mb-2">
												<input type="hidden" name="day_1" value="Monday">
												<label>Select Month</label>
												<select name="selectMonth" class="form-control">
													<option value="">--Choose--</option>
													<?php if (isset($payment[0]['month']) && $payment[0]['month'] == 'January') {?>
													<option selected value="January">January</option>
													<?php } else {?>
													<option value="January">January</option>
													<?php }?>
													<?php if (isset($payment[0]['month']) && $payment[0]['month'] == 'February') {?>
													<option selected value="February">February</option>
													<?php } else {?>
													<option value="February">February</option>
													<?php }?>
													<?php if (isset($payment[0]['month']) && $payment[0]['month'] == 'March') {?>
													<option selected value="March">March</option>
													<?php } else {?>
													<option value="March">March</option>
													<?php }?>
													<?php if (isset($payment[0]['month']) && $payment[0]['month'] == 'April') {?>
													<option selected value="April">April</option>
													<?php } else {?>
													<option value="April">April</option>
													<?php }?>
													<?php if (isset($payment[0]['month']) && $payment[0]['month'] == 'May') {?>
													<option selected value="May">May</option>
													<?php } else {?>
													<option value="May">May</option>
													<?php }?>
													<?php if (isset($payment[0]['month']) && $payment[0]['month'] == 'June') {?>
													<option selected value="June">June</option>
													<?php } else {?>
													<option value="June">June</option>
													<?php }?>
													<?php if (isset($payment[0]['month']) && $payment[0]['July'] == 'July') {?>
													<option selected value="July">July</option>
													<?php } else {?>
													<option value="July">July</option>
													<?php }?>
													<?php if (isset($payment[0]['month']) && $payment[0]['month'] == 'August') {?>
													<option selected value="August">August</option>
													<?php } else {?>
													<option value="August">August</option>
													<?php }?>
													<?php if (isset($payment[0]['month']) && $payment[0]['month'] == 'September') {?>
													<option selected value="September">September</option>
													<?php } else {?>
													<option value="September">September</option>
													<?php }?>
													<?php if (isset($payment[0]['month']) && $payment[0]['month'] == 'October') {?>
													<option selected value="October">October</option>
													<?php } else {?>
													<option value="October">October</option>
													<?php }?>
													<?php if (isset($payment[0]['month']) && $payment[0]['month'] == 'November') {?>
													<option selected value="November">November</option>
													<?php } else {?>
													<option value="November">November</option>
													<?php }?>
													<?php if (isset($payment[0]['month']) && $payment[0]['month'] == 'December') {?>
													<option selected value="December">December</option>
													<?php } else {?>
													<option value="December">December</option>
													<?php }?>
												</select>
											</div>
											<div class="col-md-4 mb-2">
												<input type="hidden" name="day_1" value="Monday">
												<label>Select Year</label>
												<select name="selectYear" class="form-control">
													<?php if (isset($payment[0]['year'])) {?>
													<?php if (isset($payment[0]['year']) && $payment[0]['year'] == '2021') {?>
													<option value="2021" selected>2024</option>
													<?php } else {?>
													<option value="2021">2021</option>
													<?php }?>

													<?php if (isset($payment[0]['year']) && $payment[0]['year'] == '2022') {?>
													<option value="2022" selected>2025</option>
													<?php } else {?>
													<option value="2022">2022</option>
													<?php }?>

													<?php if (isset($payment[0]['year']) && $payment[0]['year'] == '2023') {?>
													<option value="2023" selected>2026</option>
													<?php } else {?>
													<option value="2023">2023</option>
													<?php }?>
													<?php } else {?>
													<option value="2021" <?php echo date('Y') == 2021 ? "selected" : ""; ?>>2024
													</option>
													<option value="2022" <?php echo date('Y') == 2022 ? "selected" : ""; ?>>2025
													</option>
													<option value="2023" <?php echo date('Y') == 2023 ? "selected" : ""; ?>>2026
													</option>
													<?php }?>
												</select>
											</div>

											<div class="row"
												style="margin-bottom: 5px; border-bottom: 1px solid #d7d6d6; display: block; width: 100%; margin-top: 20px; margin-bottom: 20px;">
												<h4 style="margin-left: 13px;">Monday</h4>
											</div>

											<div class="col-md-4 mb-2">
												<input type="hidden" name="day_1" value="Monday">
												<input type="hidden" name="itemId_1" value={{@$payment[0]->id}}>
												<label>Name of Aggregator</label>
												<div class="select2-dark mb-3" data-select2-id="76">
													<div class="position-relative" data-select2-id="75">
														<select name="total_aggregator_1[]" id="total_aggregator_1"
															class="select2 form-select select2-hidden-accessible" multiple=""
															data-select2-id="select2Dark" tabindex="-1" aria-hidden="true">
															<option value="0">None</option>
															<?php if (isset($payment[0]['total_aggregator'])) {
					$payment[0]['total_aggregator'] = explode(",", $payment[0]['total_aggregator']);
				}?>
															@foreach ($aggregators as $aggregator)
																<option <?php echo isset($payment[0]['total_aggregator']) && in_array($aggregator['id'], $payment[0]['total_aggregator']) ? "selected" : ""; ?> value="{{$aggregator->id}}">
																	{{$aggregator->company_name}}</option>
															@endforeach
														</select>

													</div>
												</div>

											</div>


											<div class="col-md-4 mb-2">
												<label>Enter Aggregator Amount</label> <input
													value="{{@$payment[0]->aggregator_amount / 4}}" type="number" step=".01" min="0"
													max="100" id="aggregator_amount_1" required name="aggregator_amount_1"
													class="form-control" placeholder="Enter aggregator amount">
												@error('aggregator_amount') <span class="invalid-feedback" role="alert">
													<strong>{{ $message }}</strong>
												</span> @enderror
											</div>
											<div class="col-md-4 mb-2">
												<label>Enter Cook Amount</label> <input value="{{@$payment[0]->cook_amount / 4}}"
													type="number" step=".01" min="0" max="100" id="cook_amount_1" required
													name="cook_amount_1" class="form-control" placeholder="Enter cook amount">
												@error('cook_amount') <span class="invalid-feedback" role="alert">
													<strong>{{ $message }}</strong>
												</span> @enderror
											</div>

										</div>

										<div class="row"
											style="margin-bottom: 5px; border-bottom: 1px solid #d7d6d6; display: block; width: 100%; margin-top: 20px; margin-bottom: 20px;">
											<h4 style="margin-left: 13px;">Tuesday</h4>
										</div>

										<div class="row">

											<div class="col-md-4 mb-2">
												<input type="hidden" name="day_2" value="Monday">
												<input type="hidden" name="itemId_2" value={{@$payment[0]->id}}>
												<label>Name of Aggregator</label>
												<div class="select2-dark mb-3" data-select2-id="29">
													<div class="position-relative" data-select2-id="75">

														<select name="total_aggregator_2[]" id="total_aggregator_2"
															class="select2 form-select select2-hidden-accessible" multiple=""
															data-select2-id="select2Danger" tabindex="-1" aria-hidden="true">
															<option value="0">None</option>
															<<?php if (isset($payment[1]['total_aggregator'])) {
					$payment[0]['total_aggregator'] = explode(",", $payment[0]['total_aggregator']);
				}?>
													@foreach ($aggregators as $aggregator)
														<option <?php echo isset($payment[1]['total_aggregator']) && in_array($aggregator['id'], $payment[1]['total_aggregator']) ? "selected" : ""; ?> value="{{$aggregator->id}}">
															{{$aggregator->company_name}}</option>
													@endforeach
														</select>

													</div>
												</div>

											</div>

											<div class="col-md-4 mb-2">
												<label>Enter Aggregator Amount</label> <input
													value="{{@$payment[1]->aggregator_amount / 4}}" type="number" step=".01" min="0"
													max="100" id="aggregator_amount_2" required name="aggregator_amount_2"
													class="form-control" placeholder="Enter aggregator amount">
												@error('aggregator_amount') <span class="invalid-feedback" role="alert">
													<strong>{{ $message }}</strong>
												</span> @enderror
											</div>
											<div class="col-md-4 mb-2">
												<label>Enter Cook Amount</label> <input value="{{@$payment[1]->cook_amount / 4}}"
													type="number" step=".01" min="0" max="100" id="cook_amount_2" required
													name="cook_amount_2" class="form-control" placeholder="Enter cook amount">
												@error('cook_amount') <span class="invalid-feedback" role="alert">
													<strong>{{ $message }}</strong>
												</span> @enderror
											</div>
										</div>

										<div class="row"
											style="margin-bottom: 5px; border-bottom: 1px solid #d7d6d6; display: block; width: 100%; margin-top: 20px; margin-bottom: 20px;">
											<h4 style="margin-left: 13px;">Wednesday</h4>
										</div>

										<div class="row">

											<div class="col-md-4 mb-2">
												<input type="hidden" name="day_3" value="Wednesday">
												<input type="hidden" name="itemId_3" value={{@$payment[2]->id}}>
												<label>Name of Aggregator</label>
												<div class="select2-dark mb-3" data-select2-id="29">
													<div class="position-relative" data-select2-id="75">

														<select name="total_aggregator_3[]" id="total_aggregator_3"
															class="select2 form-select select2-hidden-accessible" multiple=""
															data-select2-id="select2Danger1" tabindex="-1" aria-hidden="true">
															<option value="0">None</option>
															<?php if (isset($payment[2]['total_aggregator'])) {
					$payment[2]['total_aggregator'] = explode(",", $payment[2]['total_aggregator']);
				}?>
															@foreach ($aggregators as $aggregator)
																<option <?php echo isset($payment[2]['total_aggregator']) && in_array($aggregator['id'], $payment[2]['total_aggregator']) ? "selected" : ""; ?> value="{{$aggregator->id}}">
																	{{$aggregator->company_name}}</option>
															@endforeach
														</select>

													</div>
												</div>

											</div>
											<div class="col-md-4 mb-2">
												<label>Enter Aggregator Amount</label> <input
													value="{{@$payment[2]->aggregator_amount / 4}}" type="number" step=".01" min="0"
													max="100" id="aggregator_amount_3" required name="aggregator_amount_3"
													class="form-control" placeholder="Enter aggregator amount">
												@error('aggregator_amount') <span class="invalid-feedback" role="alert">
													<strong>{{ $message }}</strong>
												</span> @enderror
											</div>
											<div class="col-md-4 mb-2">
												<label>Enter Cook Amount</label> <input value="{{@$payment[2]->cook_amount / 4}}"
													type="number" step=".01" min="0" max="100" id="cook_amount_3" required
													name="cook_amount_3" class="form-control" placeholder="Enter cook amount">
												@error('cook_amount') <span class="invalid-feedback" role="alert">
													<strong>{{ $message }}</strong>
												</span> @enderror
											</div>
										</div>

										<div class="row"
											style="margin-bottom: 5px; border-bottom: 1px solid #d7d6d6; display: block; width: 100%; margin-top: 20px; margin-bottom: 20px;">
											<h4 style="margin-left: 13px;">Thursday</h4>
										</div>

										<div class="row">

											<div class="col-md-4 mb-2">
												<input type="hidden" name="day_4" value="Wednesday">
												<input type="hidden" name="itemId_4" value={{@$payment[2]->id}}>
												<label>Name of Aggregator</label>
												<div class="select2-dark mb-3" data-select2-id="29">
													<div class="position-relative" data-select2-id="75">

														<select name="total_aggregator_4[]" id="total_aggregator_4"
															class="select2 form-select select2-hidden-accessible" multiple=""
															data-select2-id="select2Danger2" tabindex="-1" aria-hidden="true">
															<option value="0">None</option>
															<?php if (isset($payment[3]['total_aggregator'])) {
					$payment[3]['total_aggregator'] = explode(",", $payment[3]['total_aggregator']);
				}?>
															@foreach ($aggregators as $aggregator)
																<option <?php echo isset($payment[3]['total_aggregator']) && in_array($aggregator['id'], $payment[3]['total_aggregator']) ? "selected" : ""; ?> value="{{$aggregator->id}}">
																	{{$aggregator->company_name}}</option>
															@endforeach
														</select>

													</div>
												</div>

											</div>
											<div class="col-md-4 mb-2">
												<label>Enter Aggregator Amount</label> <input
													value="{{@$payment[3]->aggregator_amount / 4}}" type="number" step=".01" min="0"
													max="100" id="aggregator_amount_4" required name="aggregator_amount_4"
													class="form-control" placeholder="Enter aggregator amount">
												@error('aggregator_amount') <span class="invalid-feedback" role="alert">
													<strong>{{ $message }}</strong>
												</span> @enderror
											</div>
											<div class="col-md-4 mb-2">
												<label>Enter Cook Amount</label> <input value="{{@$payment[3]->cook_amount / 4}}"
													type="number" step=".01" min="0" max="100" id="cook_amount_4" required
													name="cook_amount_4" class="form-control" placeholder="Enter cook amount">
												@error('cook_amount') <span class="invalid-feedback" role="alert">
													<strong>{{ $message }}</strong>
												</span> @enderror
											</div>
										</div>

										<div class="row"
											style="margin-bottom: 5px; border-bottom: 1px solid #d7d6d6; display: block; width: 100%; margin-top: 20px; margin-bottom: 20px;">
											<h4 style="margin-left: 13px;">Friday</h4>
										</div>

										<div class="row">

											<div class="col-md-4 mb-2">
												<input type="hidden" name="day_5" value="Wednesday">
												<input type="hidden" name="itemId_5" value={{@$payment[2]->id}}>
												<label>Name of Aggregator</label>
												<div class="select2-dark mb-3" data-select2-id="29">
													<div class="position-relative" data-select2-id="75">

														<select name="total_aggregator_5[]" id="total_aggregator_5"
															class="select2 form-select select2-hidden-accessible" multiple=""
															data-select2-id="select2Danger3" tabindex="-1" aria-hidden="true">
															<option value="0">None</option>
															<?php if (isset($payment[4]['total_aggregator'])) {
					$payment[4]['total_aggregator'] = explode(",", $payment[4]['total_aggregator']);
				}?>
															@foreach ($aggregators as $aggregator)
																<option <?php echo isset($payment[4]['total_aggregator']) && in_array($aggregator['id'], $payment[4]['total_aggregator']) ? "selected" : ""; ?> value="{{$aggregator->id}}">
																	{{$aggregator->company_name}}</option>
															@endforeach
														</select>

													</div>
												</div>

											</div>
											<div class="col-md-4 mb-2">
												<label>Enter Aggregator Amount</label> <input
													value="{{@$payment[4]->aggregator_amount / 4}}" type="number" step=".01" min="0"
													max="100" id="aggregator_amount_5" required name="aggregator_amount_5"
													class="form-control" placeholder="Enter aggregator amount">
												@error('aggregator_amount') <span class="invalid-feedback" role="alert">
													<strong>{{ $message }}</strong>
												</span> @enderror
											</div>
											<div class="col-md-4 mb-2">
												<label>Enter Cook Amount</label> <input value="{{@$payment[4]->cook_amount / 4}}"
													type="number" step=".01" min="0" max="100" id="cook_amount_5" required
													name="cook_amount_5" class="form-control" placeholder="Enter cook amount">
												@error('cook_amount') <span class="invalid-feedback" role="alert">
													<strong>{{ $message }}</strong>
												</span> @enderror
											</div>
										</div>

										<div class="col-md-12 text-right">
											<br>
											@if($edit == 1)
												{{ Form::submit('Submit', ['class' => 'btn btn-primary']) }}
											@else
												{{ Form::submit('Update', ['class' => 'btn btn-primary']) }}
											@endif
										</div>
									</form>

							</div>
						</div>
					</div>
				</div>
			</div>
		@endif {{--table--}}
	<div class="col-md-12 col-lg-12">
		<div class="card">
			<div class="card-header py-2">
				<div class="d-flex justify-content-between align-items-center">
					<div>
						<h6 class="mb-0">Payment Record</h6>
					</div>
					<!--@if($can_withdraw == 1)
					<div class="text-right">
						<a href="{{ route('withdraw.create') }}"
							class="btn btn-success btn-sm mr-1"><i
							class="fas fa-money-bill mr-1"></i>Withdraw</a>
					</div>
					@endif -->
				</div>
			</div>
			<div class="card-body">
				<div class="table-responsive">
					<table class="datatables-users table border-top dataTable no-footer dtr-column" id="payment">
						<thead>
							<tr>
								<th>SL</th>
								<?php  if (Auth::user()->user_type == "Admin") {?>
								<th>State</th>
								<?php }?>
								<th>Month - Year</th>
								<th>Total Cooks</th>
								<!--	<th>Aggregator</th>-->
								<th>Total Pupils</th>
								<th>Cook Amount</th>
								<th>Aggregator Amount</th>
								<th>Total Cooks Amount</th>
								<th>Total Aggregator Amount</th>
								<th>Total Amount</th>
								<!-- 							<th>Created At</th> -->
								<th>Action</th>
							</tr>
						</thead>
						<tbody>
							@foreach ($data as $key => $record)
								<tr>
									<td>{{ $key + 1 }}</td>
									<?php  if (Auth::user()->user_type == "Admin") {?>
									<th>{{ $record->state }}</th>
									<?php }?>
									<td>{{ $record->month }} - {{ $record->year }}</td>
									<td>{{ $record->total_cook }}</td>
									<td>{{ $record->total_pupils }}</td>
									<td>{{ $record->sumcook }}</td>
									<td>{{ $record->sumaggregator }}</td>
									<td>{{ $record->totalcook }}</td>
									<td>{{ $record->totalaggregator }}</td>
									<td>{{ $record->total }}</td>

									<td><a class="btn-link" href="{{route('payment.index', ['id' => $record->id])}}"><i
												class="ti ti-edit ti-sm me-2"></i></a> <a class="btn-link"
											href="{{route('p.delete', $record->id)}}"><i class="ti ti-trash ti-sm mx-2"></i></a>
										<br>
										<a class="btn btn-sm btn-primary waves-effect waves-light"
											style="background: gray;color: white;border: 1px solid white;"
											href="{{ route('withdraw.create', ['id' => $record->id])}}">WithDraw</a>


									</td>
								</tr>
							@endforeach

						</tbody>
					</table>
				</div>
			</div>
		</div>

		{{--table end--}}
	</div>
	<script>

		//         $("[id*=total_aggregator]").change(function(){
		//             var val = this.value;
		//             var id = $(this).attr("name").split("_")[1];

		//             if (val == 0){
		//                 $("#aggregator_amount_"+id).val(val);
		//                 $("#cook_amount_"+id).val(70);
		//                 $("#cook_amount_"+id).attr('disabled',true);
		//                 $("#aggregator_amount_"+id).attr('disabled',true);
		//             }else {
		//                 $("#cook_amount_"+id).attr('disabled',false);
		//                 $("#aggregator_amount_"+id).attr('disabled',false);
		//             }
		//         });

		$("input[id*=aggregator_amount_]").change(function () {
			if ($("select[name=selectMonth]").val() == "") {
				alert("Please choose Month");
			}

			if ($("select[name=selectYear]").val() == "") {
				alert("Please choose Year");
			}

			console.log("CHNAGE");
			var amount = this.value;
			var id = $(this).attr("name").split("_")[2];

			if (amount == 0) {
				$("#cook_amount_" + id).val(100);
			}
			if (amount == 100) {
				$("#cook_amount_" + id).val(0);
			}
			if (amount > 0 && amount < 101) {
				$("#cook_amount_" + id).val(100 - amount);
			}
			if (amount > 100) {
				$("#aggregator_amount_" + id).val(100);
				$("#cook_amount_" + id).val(0);
				alert("Please enter amount equal to or less than 100");
			}
		});

		$("input[id*=cook_amount_]").change(function () {
			if ($("select[name=selectMonth]").val() == "") {
				alert("Please choose Month");
			}

			if ($("select[name=selectYear]").val() == "") {
				alert("Please choose Year");
			}

			var amount = this.value;
			var id = $(this).attr("name").split("_")[2];

			if (amount == 0) {
				$("#aggregator_amount_" + id).val(100);
			}
			if (amount == 100) {
				$("#aggregator_amount_" + id).val(0);
			}
			if (amount > 0 && amount < 101) {
				$("#aggregator_amount_" + id).val(100 - amount);
			}
			if (amount > 100) {
				$("#cook_amount_" + id).val(100);
				$("#aggregator_amount_" + id).val(0);
				alert("Please enter amount equal to or less than 100");
			}
		});
	</script>
@endsection @section('custom-js')
	<script>
		$(document).ready(function () {
			$("#payment").DataTable({
				"info": false
			});
		});

	</script>
@endsection