@extends('layouts.master')

@section('title', 'Withdraw Request')

@section('content')

    <div class="row">
        {{--table--}}
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-0">Withdraw request</h6>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="datatables-users table border-top dataTable no-footer dtr-column" id="withdraw">
                            <thead>
                            <tr>
                                <th>SL</th>
                                <th>Month</th>
                                <th>Manager Name</th>
                                <th>State Name</th>
                                <th>Cooks Amount</th>
                                <th>Aggregator Amount</th>
                                <th>Withdraw Amount</th>
                                <th>Status</th>
                                <th>Requested At</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach ($data as $key => $record)
                                @php
                                    $manager_name = \App\User::where('id','=',$record->manager_id)->first();
                                @endphp
                                <tr>
                                    <td>{{ $key+1 }}</td>
                                    <td><?php echo date("F", strtotime($record['withdraw_month'])); ?></td>
                                    <td>{{ $manager_name->name }}</td>
                                    <td>{{ $manager_name->state }}</td>
                                    <td>{{ $record->cook_amount }}</td>
                                    <td>{{ $record->aggregator_amount }}</td>
                                    <td>{{ $record->withdraw_amount }}</td>
                                    @if($record->status =="Approved")
                                    <td><span class="badge bg-label-success" text-capitalized="">Approved</span></td>
                                    @endif
                                    @if($record->status =="Pending")
                                    <td><span class="badge bg-label-warning" text-capitalized="">Pending</span></td>
                                    @endif
                                    @if($record->status =="Rejected")
                                    <td><span class="badge bg-label-warning" text-capitalized="">Rejected</span></td>
                                    @endif
                                    <td>{{ $record->created_at->diffForHumans() }}</td>
                                    @if(auth()->user()->user_type == "Admin")
                                    <td width="170px">
                                        <a class="btn-link" href="{{route('withdraw.detail',$record->id)}}"><i class="ti ti-eye ti-sm mx-2"></i></a>
                                        <a class="btn-link" href="{{route('withdraw.edit',$record->id)}}"><i class="ti ti-edit ti-sm me-2"></i></a>
                                        <a class="btn-link" href="{{route('w.delete',$record->id)}}"><i class="ti ti-trash ti-sm mx-2"></i></a>
                                        <a class="btn-link" href="{{route('withdraw.show',$record->id)}}"><i class="ti ti-check ti-sm mx-2"></i></a>
                                    </td>
                                        @else
                                        <td width="170px">
                                            <a class="btn-link" href="{{route('withdraw.detail',$record->id)}}"><i class="ti ti-eye ti-sm mx-2"></i></a>
                                            <a class="btn-link" href="{{route('withdraw.edit',$record->id)}}"><i class="ti ti-edit ti-sm me-2"></i></a>
                                            <a class="btn-link" href="{{route('w.delete',$record->id)}}"><i class="ti ti-trash ti-sm mx-2"></i></a>
                                        </td>
                                        @endif
                                </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        {{--table end--}}
    </div>
@endsection
@section('custom-js')
        <script>
            $(document).ready(function() {
                // $("#withdraw").DataTable({
                //     "info":     false,
                //     dom: 'Bfrtip',
                //     buttons: [
                //         {
                //             extend: 'copyHtml5',
                //             text: 'Copy',
                //             titleAttr: 'Copy',
                //             title: 'NSFRS',
                //             exportOptions: {
                //                 columns: ':not(:last-child)',
                //             }
                //         },
                //         {
                //             extend: 'excelHtml5',
                //             text: 'Excel',
                //             titleAttr: 'Excel',
                //             title: 'NSFRS',
                //             exportOptions: {
                //                 columns: ':not(:last-child)',
                //             }
                //         },
                //         {
                //             extend: 'pdfHtml5',
                //             text: 'PDF',
                //             titleAttr: 'PDF',
                //             title: 'NSFRS',
                //             exportOptions: {
                //                 columns: ':not(:last-child)',
                //             }
                //         },
                //         {
                //             extend: 'csvHtml5',
                //             text: 'CSV',
                //             titleAttr: 'CSV',
                //             title: 'NSFRS',
                //             exportOptions: {
                //                 columns: ':not(:last-child)',
                //             }
                //         }
                //     ],
                // });
            });
        </script>
@endsection
