@extends('layouts.master')
@section('custom-css')
     <style>
         .card-header{
         display: flex;
         justify-content :space-between;
     }
     </style>
@endsection
@section('content')
<div class="card">
    <div class="card-header">
        <div class="title">
            <h4> <i class="fa fa-plus"></i> Add New Blog</h4>  
        </div>
         
          <div class="button">
              @can('post-list')
            <a href="{{ url('posts') }}" class="btn btn-primary"> <i class="fa fa-list"></i> Blog  List </a>
             @endcan  
        </div>
    </div>
    <div class="card-body">
        {!! Form::open(array('route'=> 'posts.store', 'class'=>'form-horizontal', 'files' => true)) !!}

        <div class="row form-group">  
            <div class="col-md-8">
                {{ Form::label('title', 'Title') }}
                {{ Form::text('title', '',  array('class' => 'form-control')) }}
            </div>
        </div>


        {{-- <div class="row form-group">  
            <div class="col-md-8">
                {{ Form::label('categories', 'Category', array('style' => 'display:block')) }}
                @foreach($categories as $category)
               {{ Form::checkbox('categories[]', $category->id, false, array('class' => '')) }}  {{ $category->category}},    
               @endforeach
            </div>
        </div> --}}

       
        <div class="row form-group">  
            <div class="col-md-8">
                {{ Form::label('description', 'Description ') }} 
                {{ Form::textarea('description', '',  array('class' => 'form-control textarea')) }}
            </div>
        </div>
    
        <div class="row form-group">  
            <div class="col-md-8">
                {{ Form::label('thumbnail', 'Thumbnail',array('style' => 'display:block')) }}
                    <span class="btn-file">{{ Form::file('thumbnail', array('class'=>' btn-file')) }}
    
                    @if($errors->has('thumbnail'))
                        <span class="help-block" style="display:block">
              <strong>{{ $errors->first('thumbnail') }}</strong>
                       </span>
                    @endif
            </div>
        </div>

       @if(auth()->user()->hasrole('Admin'))
       <div class="row form-group">  
        <div class="col-md-8">
            {{ Form::label('post_type', 'Type') }}
            {{ Form::select('post_type', ['slider' => 'slider', 'post' => 'post'], null,  array('class' => 'form-control')) }}
        </div>
    </div>
       <div class="row form-group">  
        <div class="col-md-8">
            {{ Form::label('status', 'Status') }}
            {{ Form::select('status', ['published' => 'published', 'draft' => 'draft', 'pending' => 'pending'], null,  array('class' => 'form-control', 'placeholder' => '--please select--')) }}
        </div>
    </div>
    @else
       <div class="row form-group">  
        <div class="col-md-8">
            {{ Form::label('status', 'Status') }}
            {{ Form::select('status', ['draft' => 'draft', 'pending' => 'pending'], null,  array('class' => 'form-control', 'placeholder' => '--please select--')) }}
        </div>
    </div>
    @endif

        <div class="row form-group">
            <div class="col-md-4"></div>
            <div class="col-md-8" style="margin-top: 10px;">
                {{-- {{ Form::reset('Reset', array('class'=> 'btn btn-warning','style'=>'background:"none!"!important')) }} --}}
                <button type="button" type = "reset" class="btn btn-warning waves-effect waves-light">Reset</button>
                {{-- {{ Form::submit('Create', array('class' => 'btn btn-primary')) }}</div> --}}
                <button type="button" type = "submit" class="btn btn-primary waves-effect waves-light">Create</button>
        </div>

        {!! Form::close() !!}

    </div>
  </div>        
@endsection

