@extends('layouts.master')
@section('content')
    <div class="row">
        <div class="col-sm-12 col-md-12">
            <div class="card ">
                <div class="card-body">
                    @if(session()->has('message'))
                        <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="alert alert-{{session('type')}}" role="alert">
                                {{session('message')}}
                            </div>
                        </div>
                    @endif
                    <div class="table-responsive">
                        <table class="datatables-users table border-top dataTable no-footer dtr-column" id="category">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Report</th>
                                    <th>Name</th>
                                    <th>Head Name</th>
                                    <th>Address</th>
                                    <th>State</th>
                                    <th>LGA</th>
                                    <th>Phone</th>
                                    <th>Students</th>
                                    <th>Report Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            @php
                                $i = ($reports->perPage() * ($reports->currentPage() - 1)) + 1;
                            @endphp
                                @foreach ($reports as $school)
                                    <tr>
                                        <td>{{ $i++ }}</td>
                                        <td>{{ $school->report }}</td>
                                        <td id="school_{{$school->school->id}}">{{ $school->school->name }}</td>
                                        <td>{{ $school->school->contact_person }}</td>
                                        <td>{{ $school->school->address }}</td>
                                        <td>{{ \App\State::get_state($school->school->state) }}</td>
                                        <td>{{ $school->school->lga }}</td>
                                        <td>{{ $school->school->phone }}</td>
                                        <td>{{ $school->school->students }}</td>
                                        {{-- <td>{{ $school->is_active == 1 ? 'Active' : 'Inactive' }}</td> --}}
                                        @if($school->status =="Approved")
                                        <td><span class="badge bg-label-success" text-capitalized="">Approved</span></td>
                                        @endif
                                        @if($school->status =="Pending")
                                        <td><span class="badge bg-label-warning" text-capitalized="">Pending</span></td>
                                        @endif
                                        @if($school->status =="Rejected")
                                        <td><span class="badge bg-label-warning" text-capitalized="">Rejected</span></td>
                                        @endif
                                        <td>
                                            <a href="{{ url('delete-report', $school->id) }}"  title="Update" style="margin-right:3px"><i class="ti ti-trash ti-sm mx-2"></i></a>
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                     <div class="row text-center">
                         <div class="col-md-12 text-center">
                             {{ $reports->links() }}
                         </div>
                     </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Report Against : <b class="text-danger" id="school_name"></b></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="" method="post">
                    <div class="modal-body">
                        <input id="school" type="hidden" name="school_id" value="">
                        <textarea name="report" class="form-control" required placeholder="Enter Report"></textarea>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="button" class="btn btn-primary">Report</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('custom-js')
    <script>
    $(document).ready(function() {
      $("#category").DataTable({
          "paging":   true,
          "info":     false
      });
    });
        function set_id(id){
            $("#school").val(id);
            var name = $("#school_"+id).text();
            $("#school_name").text(name);
        }
        
    </script>
@endsection
