@extends('layouts.master')
@section('title', 'Role Management')
@section('content')
    <div class="row">
        <div class="col-lg-12 margin-tb">
            <div class="pull-left">
                <h2>Role Management
                    @can('role-create')
                    <a class="btn btn-success" href="{{ route('roles.create') }}"> Create New Role</a>
                @endcan
                </h2>
            </div>
        </div>
    </div>


    {{-- @if ($message = Session::get('success'))
        <div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>
    @endif --}}


    <table class="datatables-users table border-top dataTable no-footer dtr-column" id="roles">
       <thead>
        <tr>
            <th>No</th>
            <th>Name</th>
            <th width="280px">Action</th>
        </tr>
       </thead>
     <tbody>
        @foreach ($roles as $key => $role)
        <tr>
            <td>{{ ++$i }}</td>
            <td>{{ $role->name }}</td>
            <td>
                {{-- <a class="btn btn-info" href="{{ route('roles.show',$role->id) }}">Show</a>
                @can('role-edit')
                    <a class="btn btn-primary" href="{{ route('roles.edit',$role->id) }}">Edit</a>
                @endcan
                @can('role-delete')
                    {!! Form::open(['method' => 'DELETE','route' => ['roles.destroy', $role->id],'style'=>'display:inline']) !!}
                    {!! Form::submit('Delete', ['class' => 'btn btn-danger', 'id' => 'delete']) !!}
                    {!! Form::close() !!}
                @endcan --}}
                    <a class="ti ti-eye ti-sm mx-2" href="{{ route('roles.show',$role->id) }}"></a>
                    <a class="ti ti-edit ti-sm mx-2" href="{{ route('roles.edit',$role->id) }}"></a>
                    {{-- {!! Form::open(['method' => 'DELETE','route' => ['users.destroy', $user->id],'style'=>'display:inline']) !!}
                    {!! Form::submit('Delete', ['class' => 'btn btn-danger waves-effect waves-light', 'id' => 'delete']) !!}
                    {!! Form::close() !!} --}}
                    <a href="{{ route('roles.destroy', $role->id) }}"  type="submit" title="Update" style="margin-right:3px"><i class="ti ti-trash ti-sm mx-2"></i></a>
            </td>
        </tr>
    @endforeach
     </tbody>
    </table>


    {{-- {!! $roles->render() !!} --}}

@endsection

@section('custom-js')
     <script>
          $(document).ready(function() {
            $("#roles").DataTable();
        })
     </script>
@endsection
