@php
    $school = $school ?? null;
@endphp

<div class="row form-group">
    <div class="col-md-2">
        <label for="name">Name of School <strong class="text-danger">*</strong></label>
    </div>
    <div class="col-md-6">
        <input type="text" name="name" id="name" value="{{ old('name', optional($school)->name) }}" class="form-control" required>
    </div>
</div>

<div class="row form-group">
    <div class="col-md-2">
        <label for="contact_person">School Head <strong class="text-danger">*</strong></label>
    </div>
    <div class="col-md-6">
        <input type="text" name="contact_person" id="contact_person" value="{{ old('contact_person', optional($school)->contact_person) }}" class="form-control" required>
    </div>
</div>

<div class="row form-group">
    <div class="col-md-2">
        <label for="address">Address of School <strong class="text-danger">*</strong></label>
    </div>
    <div class="col-md-6">
        <input type="text" name="address" id="address" value="{{ old('address', optional($school)->address) }}" class="form-control" required>
    </div>
</div>

<div class="row form-group">
    <div class="col-md-2">
        <label for="state">State <strong class="text-danger">*</strong></label>
    </div>
    <div class="col-md-6">
        <select name="state" id="state" class="form-control" required>
            <option value="">--please select--</option>
            @foreach ($states as $state)
                <option value="{{ $state->id }}" {{ old('state', optional($school)->state) == $state->id ? 'selected' : '' }}>
                    {{ $state->name }}
                </option>
            @endforeach
        </select>
    </div>
</div>

<div class="row form-group">
    <div class="col-md-2">
        <label for="lga">LGA <strong class="text-danger">*</strong></label>
    </div>
    <div class="col-md-6">
        <select name="lga" id="lga" class="form-control" required>
            <option value="">{{ Request::route()->named('school.edit') ? '--state select first--' : '--select state first--' }}</option>
            @if(Request::route()->named('school.edit') && isset($lga))
                @foreach ($lga as $name => $display)
                    <option value="{{ $name }}" {{ old('lga', optional($school)->lga) == $name ? 'selected' : '' }}>
                        {{ $display }}
                    </option>
                @endforeach
            @endif
        </select>
    </div>
</div>

<div class="row form-group">
    <div class="col-md-2">
        <label for="phone">School Head Phone Number <strong class="text-danger">*</strong></label>
    </div>
    <div class="col-md-6">
        <input type="text" name="phone" id="phone" value="{{ old('phone', optional($school)->phone) }}" class="form-control" required>
    </div>
</div>

<div class="row form-group">
    <div class="col-md-2">
        <label for="students">Number of Students <strong class="text-danger">*</strong></label>
    </div>
    <div class="col-md-6">
        <input type="number" name="students" id="students" value="{{ old('students', optional($school)->students) }}" class="form-control" required>
    </div>
</div>

@if(auth()->user()->hasRole('Admin'))
    <div class="row form-group">
        <div class="col-md-2">
            <label for="status">Status</label>
        </div>
        <div class="col-md-6">
            <select name="status" id="status" class="form-control">
                @foreach (\App\Helpers\StaticData::account_status() as $statusKey => $statusValue)
                    <option value="{{ $statusKey }}" {{ old('status', optional($school)->status) == $statusKey ? 'selected' : '' }}>
                        {{ $statusValue }}
                    </option>
                @endforeach
            </select>
        </div>
    </div>
@else
    <div class="row form-group">
        <div class="col-md-2">
            <label for="status">Status</label>
        </div>
        <div class="col-md-6">
            <select name="status" id="status" class="form-control">
                <option value="Pending" {{ old('status', optional($school)->status) == 'Pending' ? 'selected' : '' }}>Pending</option>
            </select>
        </div>
    </div>
@endif

@push('scripts')
<script>
    $(document).ready(function () {
        $('#state').select2();
        let CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
        let state_name = '';

        $("#state").on('change', function () {
            state_name = $(this).val();
        });

        $("#lga").select2({
            ajax: {
                url: "{{ url('get-lga') }}",
                type: "GET",
                dataType: 'json',
                data: function (params) {
                    return {
                        _token: CSRF_TOKEN,
                        search: params.term,
                        state: state_name,
                    };
                },
                processResults: function (response) {
                    return {
                        results: response
                    };
                },
                cache: true
            }
        });
    });
</script>
@endpush
