@extends('layouts.master')
@section('content')

    <div class="row">
        <div class="col-sm-12 col-md-12">
            <div class="card ">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="fs-17 font-weight-600 mb-0">State School List</h6>
                        </div>
                        <div class="text-right">
                            {{-- @can('school-create')
                                <a href="{{ route('school.create') }}" class="btn btn-success btn-sm mr-1"><i
                                        class="fas fa-plus mr-1"></i>Add New School</a>
                            @endcan --}}
                        </div>
                    </div>
                </div>
                <div class="card-body">

                    <div class="table-responsive">
                        <table class="datatables-users table border-top dataTable no-footer dtr-column" id="category">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Name</th>
                                    <th>Head Name</th>
                                    <th>Address</th>
                                    <th>State</th>
                                    <th>LGA</th>
                                    <th>Phone</th>
                                    <th>Students</th>
                                    <th>Status</th>
                                    @if(auth()->user()->can('school-edit') || auth()->user()->can('school-delete'))
                                    <th>Action</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                            @php
                                $i = ($schools->perPage() * ($schools->currentPage() - 1)) + 1;
                            @endphp
                                @foreach ($schools as $school)
                                    <tr>
                                        <td>{{ $i++ }}</td>
                                        <td>{{ $school->name }}</td>
                                        <td>{{ $school->contact_person }}</td>
                                        <td>{{ $school->address }}</td>
                                        <td>{{ \App\State::get_state($school->state) }}</td>
                                        <td>{{ $school->lga }}</td>
                                        <td>{{ $school->phone }}</td>
                                        <td>{{ $school->students }}</td>
                                        {{-- <td>{{ $school->is_active == 1 ? 'Active' : 'Inactive' }}</td> --}}
                                        <td>{{ $school->status }}</td>
                                        @if(auth()->user()->can('school-edit') || auth()->user()->can('school-delete'))
                                        <td class="form-inline">
                                            @can('school-edit')
                                                <a href="{{ route('school.edit', $school->id) }}" title="Update" style="margin-right:3px"><i class="ti ti-edit ti-sm mx-2"></i></a>
                                            @endcan
                                            @can('school-delete')
                                                    <a href="{{ route('school.destroy', $school->id) }}"  title="Update" style="margin-right:3px"><i class="ti ti-trash ti-sm mx-2"></i></a>
                                                {{-- {!! Form::open(['method' => 'DELETE', 'route' => ['school.destroy', $school->id]]) !!}
                                                {{ Form::button('<i class="ti ti-trash ti-sm mx-2"></i>', ['type' => 'submit', 'class' => '', 'id' => 'delete', 'title' => 'Delete']) }}
                                                {!! Form::close() !!} --}}
                                            @endcan
                                        </td>
                                        @endcan
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="row text-center">
                        <div class="col-md-12 text-center">
                            {{ $schools->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
@section('custom-js')
<script>
    $(document).ready(function() {
      $("#category").DataTable({
          "paging":   false,
          "info":     false
      });
    });
</script>
@endsection
