@extends('layouts.master')
@section('content')

<div class="row">
    <div class="col-sm-12 col-md-12">
        <div class="card ">
            <div class="card-header py-2">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="fs-17 font-weight-600 mb-0">List of Suggested School</h6>
                    </div>
                </div>
            </div>
            <div class="card-body">

                <div class="table-responsive">
                    <table class="table display table-bordered table-striped table-hover custom-table" id="category">
                        <thead>
                        <tr>
                            <th>SL</th>
                            <th>School Name</th>

                            <th>Head Name</th>
                            <th>Address</th>
                            <th>State</th>
                            <th>LGA</th>
                            <th>Phone</th>

                            <th>Status</th>
                            @if(auth()->user()->can('school-edit') || auth()->user()->can('school-delete'))
                            <th>Action</th>
                            @endif
                        </tr>
                        </thead>
                        <tbody>
                        @php
                        $i = ($schools->perPage() * ($schools->currentPage() - 1)) + 1;
                        @endphp
                        @foreach ($schools as $school)
                        <tr>
                            <td>{{ $i++ }}</td>
                            <td id="school_{{$school->id}}">{{ $school->name }}</td>

                            <td>{{ $school->contact_person }}</td>
                            <td>{{ $school->address }}</td>
                            <td>{{ \App\State::get_state($school->state) }}</td>
                            <td>{{ $school->lga }}</td>
                            <td>{{ $school->phone }}</td>

                            {{-- <td>{{ $school->is_active == 1 ? 'Active' : 'Inactive' }}</td> --}}
                            <td>{{ $school->status }}</td>
                            @if(auth()->user()->can('school-edit') || auth()->user()->can('school-delete'))
                            <td class="form-inline">
                                @can('school-edit')
                                <a href="{{ route('school.edit', $school->id) }}"
                                   class="btn btn-success btn-xs" title="Update" style="margin-right:3px"><i
                                        class="fas fa-edit"></i></a>
                                @endcan
                                @can('school-delete')
                                {!! Form::open(['method' => 'DELETE', 'route' => ['school.destroy', $school->id]]) !!}
                                {{ Form::button('<i class="fa fa-trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-xs', 'id' => 'delete', 'title' => 'Delete']) }}
                                {!! Form::close() !!}
                                @endcan
                            </td>
                            @endcan
                        </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
                <div class="row text-center">
                    <div class="col-md-12 text-center">
                        {{ $schools->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Report Against : <b class="text-danger" id="school_name"></b></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="" method="post">
                <div class="modal-body">
                    <input id="school" type="hidden" name="school_id" value="">
                    <textarea name="report" class="form-control" required placeholder="Enter Report"></textarea>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary">Report</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('custom-js')
<script>
    function set_id(id){
        $("#school").val(id);
        var name = $("#school_"+id).text();
        $("#school_name").text(name);
    }
    $(document).ready(function() {
        $("#category").DataTable({
            "paging":   true,
            "info":     false
        });
    });
</script>
@endsection
