<?php
define("URL", "https://schoolreport.site");

?>
<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>NATIONAL SCHOOL FEEDING REPORTING SYSTEM</title>

    <meta name="description" content="" />


    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="/asset/assets/img/favicon/favicon.ico" />


    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet" />

    <!-- Icons -->
    <link rel="stylesheet" href="/asset/assets/vendor/fonts/fontawesome.css" />
    <link rel="stylesheet" href="/asset/assets/vendor/fonts/tabler-icons.css" />
    <link rel="stylesheet" href="/asset/assets/vendor/fonts/flag-icons.css" />
    <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <!-- Core CSS -->
    <link rel="stylesheet" href="asset/assets/vendor/css/rtl/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="/asset/assets/vendor/css/rtl/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="/asset/assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="/asset/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="/asset/assets/vendor/libs/node-waves/node-waves.css" />
    <link rel="stylesheet" href="/asset/assets/vendor/libs/typeahead-js/typeahead.css" />
    <link rel="stylesheet" href="/asset/assets/vendor/libs/apex-charts/apex-charts.css" />
    <!-- Vendors CSS -->
    <link rel="stylesheet" href="/asset/assets/vendor/libs/select2/select2.css" />
    <link rel="stylesheet" href="/backend/plugins/select2/css/select2.min.css" />
    <script src="/asset/assets/vendor/libs/bootstrap-select/bootstrap-select.js"></script>
    <link rel="stylesheet" href="/asset/assets/vendor/libs/bootstrap-select/bootstrap-select.css" />

    <link rel="stylesheet" href="/asset/assets/vendor/libs/flatpickr/flatpickr.css" />
    <!-- Row Group CSS -->

    <!-- Form Validation -->
    <link rel="stylesheet" href="/asset/assets/vendor/libs/formvalidation/dist/css/formValidation.min.css" />
    <link rel="stylesheet" href="/asset/assets/vendor/css/pages/app-chat.css" />
    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="/asset/assets/vendor/js/helpers.js"></script>


    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Template customizer: To hide customizer set displayCustomizer value false in config.js.  -->

    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->

    <!-- <script src="/asset/assets/vendor/js/template-customizer.js"></script> -->
    <script src="/asset/assets/js/config.js"></script>
    <link rel="stylesheet" href="/asset/assets/vendor/libs/formvalidation/dist/css/formValidation.min.css" />





</head>

<body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-navbar-full layout-horizontal layout-without-menu">
        <div class="layout-container">
            <!-- Navbar -->

            <nav class="layout-navbar navbar navbar-expand-xl align-items-center bg-navbar-theme" id="layout-navbar">
                <div class="container-xxl">
                    <div class="navbar-brand app-brand demo d-none d-xl-flex py-0 me-4">
                        <a href="index.html" class="app-brand-link gap-2">
                            <img src="asset/wel/assets/img/logo.png" alt="quantech">
                        </a>

                        <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto d-xl-none">
                            <i class="ti ti-x ti-sm align-middle"></i>
                        </a>
                    </div>

                    <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                        <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                            <i class="ti ti-menu-2 ti-sm"></i>
                        </a>
                    </div>


                    <!-- Search Small Screens -->
                    <div class="navbar-search-wrapper search-input-wrapper container-xxl d-none">
                        <input type="text" class="form-control search-input border-0" placeholder="Search..." aria-label="Search..." />
                        <i class="ti ti-x ti-sm search-toggler cursor-pointer"></i>
                    </div>
                </div>
            </nav>

            <!-- / Navbar -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Content wrapper -->
                <div class="content-wrapper">

                    <!-- Content -->

                    <div class="container-xxl flex-grow-1 container-p-y">
                        <h4 class="fw-bold py-3 mb-4">
                            <span class="text-muted fw-light">Public/</span> Sponspor a School

                        </h4>
                        <!-- Form Alignment -->
                        <div class="row">
                            @if(session()->has('message'))
                            <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                <div class="alert alert-{{session('type')}}" role="alert">
                                    {{session('message')}}
                                </div>
                            </div>
                            @endif

                        </div>
                        <div class="card">

                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-center h-px-600">
                                    <form class="w-px-800 border rounded p-4 p-md-10" method="post" action="{{route('save_sponcor_school')}}">>
                                        @csrf
                                        <!-- {{ csrf_field() }} -->
                                        <h3 class="mb-4">Sponspor A School</h3>
                                        <div class="row mb-3">
                                            <label class="col-sm-2 col-form-label" for="basic-icon-default-fullname">Name</label>
                                            <div class="col-sm-10">
                                                <div class="input-group input-group-merge">
                                                    <span id="basic-icon-default-fullname2" class="input-group-text"><i class="ti ti-user"></i></span>
                                                    <input type="text" class="form-control" id="contact_person" name="contact_person" placeholder="John Doe" aria-label="John Doe" aria-describedby="basic-icon-default-fullname2" required />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <label class="col-sm-2 col-form-label" for="basic-icon-default-email">Email</label>
                                            <div class="col-sm-10">
                                                <div class="input-group input-group-merge">
                                                    <span class="input-group-text"><i class="ti ti-mail"></i></span>
                                                    <input type="text" id="email" name="email" class="form-control" placeholder="john.doe" aria-label="john.doe" aria-describedby="basic-icon-default-email2" required />
                                                    <span id="basic-icon-default-email2" class="input-group-text"></span>
                                                </div>
                                                <div class="form-text">
                                                    You can use letters, numbers & periods
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <label class="col-sm-2 form-label" for="basic-icon-default-phone">Phone
                                                No</label>
                                            <div class="col-sm-10">
                                                <div class="input-group input-group-merge">
                                                    <span id="basic-icon-default-phone2" class="input-group-text"><i class="ti ti-phone"></i></span>
                                                    <input type="tel" id="phone" name="phone" pattern="[0-9]{4} [0-9]{3} [0-9]{4}" class="form-control" data-dial-code="234" placeholder="XXXX XXX XXXX" aria-label="XXXX XXX XXXX" aria-describedby="basic-icon-default-phone2" minlength="11" required />
                                                </div>
                                                <div class="form-text">
                                                    eg. 9999 999 9999
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <label class="col-sm-2 form-label" for="basic-icon-default-message">Address</label>
                                            <div class="col-sm-10">
                                                <div class="input-group input-group-merge">
                                                    <span id="basic-icon-default-message2" class="input-group-text"><i class="ti ti-message-dots"></i></span>
                                                    <textarea id="basic-icon-default-message" name="address" id="address" class="form-control" placeholder="" aria-label="" aria-describedby="basic-icon-default-message2"></textarea>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- school fields -->


                                        <div class="row mb-3">
                                            <label class="col-sm-2 col-form-label" for="basic-icon-default-fullname">School State</label>
                                            <div class="col-sm-10">
                                                <div class="input-group input-group-merge">

                                                    {{ Form::select('state', $states, null, ['class' => 'form-select', 'required', 'id' => 'state', 'placeholder' => '--please select--']) }}

                                                </div>

                                            </div>



                                        </div>

                                        <div class="row mb-3">
                                            <label class="col-sm-2 col-form-label" for="basic-icon-default-fullname">School LGA</label>
                                            <div class="col-sm-10">


                                                {{ Form::select('lga', $lga, null, ['class' => 'form-select', 'required', 'id' => 'lga', 'placeholder' => '--select school state first--']) }}

                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <label class="col-sm-2 col-form-label" for="basic-icon-default-fullname">School Name</label>
                                            <div class="col-sm-10">
                                                <div class="input-group input-group-merge">

                                                    {{ Form::select('school_name', $school, null, ['class' => 'form-select', 'required', 'id' => 'school_name', 'placeholder' => '--select school state first--']) }}

                                                </div>
                                                <div id="res"></div>
                                            </div>
                                        </div>
                                        <div class="d-grid">
                                            <button type="submit" class="btn btn-primary">
                                                Submit
                                            </button>
                                        </div>
                                        <input type="hidden" name="status" value="Approved">
                                        <input type="hidden" name="is_sponcered" value="sponcered">

                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="content-backdrop fade"></div>
                </div>
                <!--/ Content wrapper -->
            </div>

            <!--/ Layout container -->
        </div>
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>

    <!-- Drag Target Area To SlideIn Menu On Small Screens -->
    <div class="drag-target"></div>

    <!--/ Layout wrapper -->

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="<?= URL ?>/asset/assets/vendor/libs/jquery/jquery.js"></script>
    <script src="<?= URL ?>/asset/assets/vendor/libs/popper/popper.js"></script>
    <script src="<?= URL ?>/asset/assets/vendor/js/bootstrap.js"></script>
    <script src="<?= URL ?>/asset/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js">
    </script>
    <script src="<?= URL ?>/asset/assets/vendor/libs/node-waves/node-waves.js"></script>

    <script src="<?= URL ?>/asset/assets/vendor/libs/hammer/hammer.js"></script>
    <script src="<?= URL ?>/asset/assets/vendor/libs/i18n/i18n.js"></script>
    <script src="<?= URL ?>/asset/assets/vendor/libs/typeahead-js/typeahead.js"></script>

    <script src="<?= URL ?>/asset/assets/vendor/js/menu.js"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="<?= URL ?>/asset/assets/vendor/libs/cleavejs/cleave.js"></script>
    <script src="<?= URL ?>/asset/assets/vendor/libs/cleavejs/cleave-phone.js"></script>
    <script src="<?= URL ?>/asset/assets/vendor/libs/moment/moment.js"></script>
    <script src="<?= URL ?>/asset/assets/vendor/libs/flatpickr/flatpickr.js"></script>
    <script src="<?= URL ?>/asset/assets/vendor/libs/select2/select2.js"></script>


    <!-- Main JS -->


    <!-- Page JS -->
    <script src="<?= URL ?>/asset/assets/js/form-layouts.js"></script>
    <script>
        $(document).ready(function() {
            $('#state').select2();
            // $('#school_name').select2();

            let CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
            // get state name
            let state_name = '';
            let lga_name = '';
            let school_name = '';

            $("#state").on('change', function() {
                state_name = $(this).val();

            });
            $("#lga").on('change', function() {
                lga_name = $(this).val();


            });
            $("#school_name").on('change', function() {
                school_name = $(this).val();


            });

            // state name wise lga selections
            $("#lga").select2({
                ajax: {
                    url: "{!! url('get-lga') !!}",
                    type: "get",
                    dataType: 'json',
                    //   delay: 250,
                    data: function(params) {
                        return {
                            _token: CSRF_TOKEN,
                            search: params.term, // search term
                            state: state_name, // search term
                        };
                    },
                    processResults: function(response) {

                        return {
                            results: response
                        };
                    },
                    cache: true
                }
            });

            $("#school_name").select2({
                ajax: {
                    url: "{!! url('get-all-school') !!}",
                    type: "get",
                    dataType: 'json',

                    //   delay: 250,
                    data: function(params) {
                        return {
                            _token: CSRF_TOKEN,
                            search: params.term, // search term
                            lga: lga_name, // search term

                        };
                    },
                    processResults: function(response) {

                        return {
                            results: response
                        };
                    },
                    cache: true
                }
            });




        })
    </script>
</body>

</html>