@extends('layouts.master')
@section('content')

    <div class="row">
        <div class="col-sm-12 col-md-12">
            <div class="card ">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="fs-17 font-weight-600 mb-0">List of {{ request()->path() }}</h6>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="datatables-users table border-top dataTable no-footer dtr-column" id="category">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>USER</th>
                                    <th>State</th>
                                    <th>Role</th>
                                    <th>Expire At</th>
                                </tr>
                            </thead>
                            <tbody>

                                @foreach ($state_admins as $state_admin)
                                    <tr>
                                        <td>{{ $loop->index + 1 }}</td>
                                        
                                        <td class="sorting_1">
                                            <div class="d-flex justify-content-start align-items-center user-name">
                                                <div class="avatar-wrapper">
                                                    <div class="avatar avatar-sm me-3">
                                                        <img src="{{ $state_admin->photo }}" alt="Avatar" class="rounded-circle">
                                                    </div>
                                                </div>
                                                <div class="d-flex flex-column">
                                                    <a href="app-user-view-account.html" class="text-body text-truncate">
                                                        <span class="fw-semibold">{{ $state_admin->name }}</span>
                                                    </a>
                                                <small class="text-muted">{{ $state_admin->email }}</small>
                                                </div>
                                            </div>
                                        </td>
                                        
                                        <td>{{ $state_admin->state }}</td>
                                        <td>
                                            
                                            @if(!empty($state_admin->getRoleNames()))
                                                @foreach($state_admin->getRoleNames() as $v)
                                                    @if($v=="Admin")
                                                        <span class="text-truncate d-flex align-items-center"><span class="badge badge-center rounded-pill bg-label-success w-px-30 h-px-30 me-2"><i class="ti ti-circle-check ti-sm"></i></span>{{ $v }}</span>
                                                    @endif
                                                    @if($v=="Program Manager")
                                                        <span class="text-truncate d-flex align-items-center"><span class="badge badge-center rounded-pill bg-label-warning w-px-30 h-px-30 me-2"><i class="ti ti-edit ti-sm"></i></span>{{ $v }}</span>
                                                    @endif
                                                    @if($v=="State admin")
                                                        <span class="text-truncate d-flex align-items-center"><span class="badge badge-center rounded-pill bg-label-success w-px-30 h-px-30 me-2"><i class="ti ti-device-laptop ti-sm"></i></span>{{ $v }}</span>
                                                    @endif
                                                    @if($v=="State admin")
                                                        <span class="text-truncate d-flex align-items-center"><span class="badge badge-center rounded-pill bg-label-warning w-px-30 h-px-30 me-2"><i class="ti ti-user ti-sm"></i></span>{{ $v }}</span>
                                                    @endif

                                                    
                                                @endforeach
                                            @endif
                                        </td>
                                        <td>{{ $state_admin->expired_at }}</td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
@section('custom-js')
    <script>
        $(document).ready(function() {
            $("#category").DataTable();
        });
    </script>
@endsection
