<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    {{-- fav icon --}}
    <link rel="icon" href="{{ asset('backend/dist/img/logo/fav.png') }}" type="image/gif" sizes="16x16">
    <title>NATIONAL SCHOOL FEEDING REPORTING SYSTEM </title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="{{ asset('backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <!--Start of Tawk.to Script-->
    <script type="text/javascript">
        var Tawk_API = Tawk_API || {},
            Tawk_LoadStart = new Date();
        (function() {
            var s1 = document.createElement("script"),
                s0 = document.getElementsByTagName("script")[0];
            s1.async = true;
            s1.src = 'https://embed.tawk.to/6212976e1ffac05b1d7ad09e/1fsc9v2ns';
            s1.charset = 'UTF-8';
            s1.setAttribute('crossorigin', '*');
            s0.parentNode.insertBefore(s1, s0);
        })();
    </script>
    <!--End of Tawk.to Script-->
</head>

<body>
    <div class="container">
        <div class="row">
            <br>
            <div class="col-sm-12 col-md-12 overflow-auto">
                @if(session()->has('message'))
                <div class="alert alert-{{session('type')}}" role="alert">
                    {{session('message')}}
                </div>
                @endif
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover overflow-auto" id="category">
                        <thead>
                            <tr>
                                <th>SL</th>
                                <th>Name</th>
                                {{--<th>Head Name</th>
                        <th>Address</th>--}}
                                <th>State</th>
                                <th>LGA</th>
                                {{--<th>Phone</th>--}}
                                <th>Students</th>
                                {{--<th>Status</th>--}}
                                <th>Report</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                            $i = ($schools->perPage() * ($schools->currentPage() - 1)) + 1;
                            @endphp
                            @foreach ($schools as $school)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td id="school_{{$school->id}}">{{ $school->name }}</td>
                                {{--<td>{{ $school->contact_person }}</td>
                                <td>{{ $school->address }}</td>--}}
                                <td>{{ \App\State::get_state($school->state) }}</td>
                                <td>{{ $school->lga }}</td>
                                {{--<td>{{ $school->phone }}</td>--}}
                                <td>{{ $school->students }}</td>
                                {{-- <td>{{ $school->is_active == 1 ? 'Active' : 'Inactive' }}</td> --}}
                                {{--<td>{{ $school->status }}</td>--}}
                                <td>
                                    <button type="button" onclick="set_info({{$school->id}})" class="btn btn-sm btn-outline-primary" data-toggle="modal" data-target="#exampleModal">
                                        Comment
                                    </button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="row text-center">
                    <div class="col-md-12 text-center">
                        {{ $schools->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Report Against : <b class="text-danger" id="school_name"></b></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{url('send-report')}}" method="post">
                    @csrf
                    <div class="modal-body">
                        <input id="school" type="hidden" name="school_id" value="">
                        <textarea name="report" class="form-control" required placeholder="Enter Report"></textarea>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Report</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <script>
        function set_info(id) {
            $("#school").val(id);
            var name = $("#school_" + id).text();
            $("#school_name").text(name);
        }
        $(document).ready(function() {
            $("#category").DataTable({
                "paging": true,
                "info": false
            });
        });
    </script>
    <script src="{{ asset('backend/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
</body>

</html>