@extends('layouts.master')
@section('content')

    <div class="row">
        <div class="col-sm-12 col-md-12">
            <div class="card ">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="fs-17 font-weight-600 mb-0">List of Aggregators</h6>
                        </div>
                        <div class="text-right">
                            @can('aggregator-create')
                                <a href="{{ route('aggregators.create') }}" class="btn btn-success btn-sm mr-1"><i
                                        class="fas fa-plus mr-1"></i>Add Aggregator</a>
                            @endcan
                        </div>
                    </div>
                </div>
                <div class="card-body">
                	    @can('upload-cook')
                       	<div class="row mb-4">
                            <div class="col-md-3">
                                <a href="{{ asset('excel_demo/aggregator_sample_file.xlsx') }}" class="btn btn-primary" download> <i class="fas fa-download"></i> Download Sample File</a>
                                {{-- <a href="{{ url('export-school') }}" class="btn btn-info"><i class="fas fa-file-export"></i> Export File</a> --}}
                            </div>
                           
                        </div>
                        {!! Form::open(['url' => 'import-aggregatros', 'method' => 'POST', 'class' => 'form-horizontal', 'files' => true]) !!}
                          <div class="row form-group">
        
                            {{ Form::label('', 'Upload Excel File') }}
                            <div class="col-md-4 input-group mb-3"> 
                                {{ Form::file('select_file', ['class' => 'btn btn-default', 'required']) }}
                                @if($errors->has('select_file'))
                                <span class="help-block" style="display:block">
                                 <strong class="text-danger">{{ $errors->first('select_file') }}</strong>
                               </span>
                               @endif
                                <div class="input-group-append">
                                  {{ Form::submit('Submit', ['class' => 'btn btn-primary']) }}
                                </div>
                              </div>
                        </div>
                     {!! Form::close() !!}
                     @endcan
                    <div class="table-responsive">
                        <table class="table display table-bordered table-striped table-hover custom-table" id="category">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Company Name</th>
                                    <th>Bank Name</th>
                                    <th>AC No</th>
                                    <th>TIN</th>
                                    <th>Items to Supply</th>
                                    <th>Unit Cost(N)</th>
                                    <th>Day of Consumption</th>
                                    <th>Weekly Consumption</th>
                                    <th title="Number of pupils feed">Pupils</th>
                                    <th title="Cost Per Week">Cost Per Week</th>
                                    <th title="Cost 20 Days">Cost 20 days</th>
<!--                                     <th title="Amount of Feed ( amount of payment to be paid to the cook)">Amount</th> -->
                                    <th>Status/Verified</th>
                                    <th>Added By</th>
                                    @if (auth()->user()->can('aggregator-edit') ||
                                    auth()->user()->can('feeding-report') ||
                                    auth()->user()->can('aggregator-delete') ||
                                    auth()->user()->can('aggregator-suspend'))
                                        <th>Action</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                            @php
                                $i = ($aggregators->perPage() * ($aggregators->currentPage() - 1)) + 1;
                            @endphp
                                @foreach ($aggregators as $aggregator)
                                    <tr>
                                        <td>{{ $i++ }}</td>
                                        <td>{{ $aggregator->company_name }}</td>
                                        <td>{{ $aggregator->bank }}</td>
                                        <td>{{ $aggregator->account_no }}</td>
                                        <td>{{ $aggregator->tin }}</td>
                                        <td>{{ $aggregator->supply_items }}</td>
                                        <td>{{ $aggregator->unit_cost }}</td>
                                        <td>{{ $aggregator->cons_day }}</td>
                                        <td>{{ $aggregator->weekly_comsp }}</td>
                                        <td>{{ $aggregator->feed_pupils }}</td>
                                        <td>{{ $aggregator->week_cost }}</td>
                                        <td>{{ $aggregator->amount_twenty }}</td>
<!--                                         <td>{{ $aggregator->amount_to_paid_cook }}</td> -->
                                        {{-- <td>{{ $aggregator->is_active == 1 ? 'Active' : 'Inactive' }}/{{ $aggregator->is_verified == 1 ? 'Verified' : 'Unverified' }} --}}
                                        <td>{{ $aggregator->status }}/{{ $aggregator->is_verified == 1 ? 'Verified' : 'Unverified' }}
                                        </td>
                                        <td>{{ \App\Aggregator::get_state_name($aggregator->state) }}</td>
                                        @if (auth()->user()->can('aggregator-edit') ||
                                        auth()->user()->can('feeding-report') ||
                                        auth()->user()->can('aggregator-delete') ||
                                        auth()->user()->can('aggregator-suspend'))
                                            <td class="form-inline">
                                                @can('aggregator-report')
                                                    <a href="{{ route('aggregators.report', $aggregator->id) }}"
                                                        class="btn btn-info btn-xs" title="Payment Report" target="__blank"
                                                        style="margin-right:3px"><i class="fas fa-chart-line"></i></a>
                                                @endcan
                                                @can('aggregator-suspend')
                                                    <a href="javascript:void()" class="btn btn-warning btn-xs"
                                                        data-toggle="modal" data-target="#aggregator_suspend" title="Suspend"
                                                        style="margin-right:3px"><i class="fas fa-times-circle"></i></a>
                                                @endcan
                                                @can('aggregator-edit')
                                                    <a href="{{ route('aggregators.edit', $aggregator->id) }}"
                                                        class="btn btn-success btn-xs" title="Update"
                                                        style="margin-right:3px"><i class="fas fa-edit"></i></a>
                                                @endcan
                                                @can('aggregator-delete')
                                                    {!! Form::open(['method' => 'DELETE', 'route' => ['aggregators.destroy', $aggregator->id]]) !!}
                                                    {{ Form::button('<i class="fa fa-trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-xs', 'id' => 'delete', 'title' => 'Delete']) }}
                                                    {!! Form::close() !!}
                                                @endcan
                                            </td>
                                        @endif
                                    </tr>

                                    <div class="modal fade" id="aggregator_suspend">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title">Write suspend reason</h4>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    {!! Form::open(['url' => 'suspend-request-confirm', 'class' => 'form-horizontal', 'files' => true]) !!}
                                                    {!! Form::hidden('type', 'aggregators') !!}
                                                    {!! Form::hidden('cooks_aggregators_id', $aggregator->id) !!}
                                                    <textarea name="reason" rows="5"
                                                        placeholder="Why do you want to suspend his/her"
                                                        class="form-control" required></textarea>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-danger"
                                                        data-dismiss="modal">Cancel</button>
                                                    <button type="submit" class="btn btn-primary">Confirm</button>
                                                    {!! Form::close() !!}
                                                </div>
                                            </div>
                                            <!-- /.modal-content -->
                                        </div>
                                        <!-- /.modal-dialog -->
                                    </div>
                                    <!-- /.modal -->


                                @endforeach

                            </tbody>
                        </table>
                    </div>
                    <div class="row text-center">
                        <div class="col-md-12 text-center">
                            {{ $aggregators->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
@section('custom-js')
    <script>
        $(document).ready(function() {
            $("#category").DataTable({
                "info":     false
            });
        });
    </script>
@endsection
