@extends('layouts.master')
@section('custom-css')
    <style>
        .import_btn{
              margin-top: 9px;
              margin-left: -46px;
        }
    </style>
@endsection

@section('content')

    <div class="row">
        <div class="col-sm-12 col-md-12">
            <div class="card ">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="fs-17 font-weight-600 mb-0">List of Pupils Request
                           </h6>
                            
                        </div>
                        <div class="text-right">
                            @can('feeding-list')
                                <a href="{{ route('feedings.index') }}" class="btn btn-success btn-sm mr-1"><i
                                        class="fas fa-list mr-1"></i>Pupils List</a>
                            @endcan
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">   
                        <table class="table display table-bordered table-striped table-hover custom-table" id="category"> 
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Date</th>
                                    <th>Manager Name</th>
                                    <th>Cook</th>
                                    <th>Aggregator</th>
                                    <th>School</th>
                                    <th>Day</th>
                                    <th>Item Name</th>
                                    <th>Unit Cost</th>
                                    <th>Pupils</th>
                                    <th>Payable</th>
                                    <th>Paid</th>
                                    <th>Status</th>
                                    @if(auth()->user()->can('feeding-edit') || auth()->user()->can('feeding-delete'))
                                    <th>Action</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                        
                                @foreach ($feedings as $feeding)
                                    <tr>
                                        <td>{{ $loop->index + 1 }}</td>
                                        <td>{{ $feeding->feeding_date }}</td>

                                        @if(\App\Helpers\StaticData::checkManagers($feeding->manager_id))
                                        <td>{{ \App\User::get_user_name($feeding->manager_id) }}</td>
                                        @else 
                                        <td></td>
                                        @endif
                                       
                                        @if(\App\Helpers\StaticData::checkCooks($feeding->cooks_id))
                                        <td> {{ $feeding->cooks->full_name }}</td>
                                        @else 
                                        <td></td>
                                        @endif

                                        @if(\App\Helpers\StaticData::checkAggregators($feeding->aggregators_id))
                                        <td>{{ $feeding->aggregator->company_name }}</td>
                                        @else 
                                        <td></td>
                                        @endif


                                        @if(\App\Helpers\StaticData::checkSchools($feeding->school_id))
                                        <td>{{ $feeding->school->name }}</td>
                                        @else 
                                        <td></td>
                                        @endif
                                       
                                        <td>{{ $feeding->day }}</td>
                                        <td>{{ $feeding->items }}</td>
                                        <td>{{ $feeding->unit_cost }}</td>
                                        <td>{{ $feeding->pupils }}</td>
                                        <td>{{ $feeding->payable_amount }}</td>
                                        <td>{{ $feeding->paid }}</td>
                                        <td>{{ $feeding->status }}</td>
                                        @if(auth()->user()->can('feeding-edit') || auth()->user()->can('feeding-delete'))
                                        <td class="form-inline">
                                            @can('feeding-view')
                                            <a href="{{ route('feedings.show', $feeding->id) }}"
                                                class="btn btn-info btn-xs" title="View Details" style="margin-right:3px"><i
                                                    class="fas fa-eye"></i></a>
                                        @endcan
                                            @can('feeding-edit')
                                                <a href="{{ route('feedings.edit', $feeding->id) }}"
                                                    class="btn btn-success btn-xs" title="Update" style="margin-right:3px"><i
                                                        class="fas fa-edit"></i></a>
                                            @endcan
                                            @can('feeding-delete')
                                                {!! Form::open(['method' => 'DELETE', 'route' => ['feedings.destroy', $feeding->id]]) !!}
                                                {{ Form::button('<i class="fa fa-trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-xs', 'id' => 'delete', 'title' => 'Delete']) }}
                                                {!! Form::close() !!}
                                            @endcan
                                        </td>
                                        @endif
                                    </tr>
                                @endforeach
                        
                            </tbody>
                        </table>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
@section('custom-js')
    <script>
        $(document).ready(function() {
            $("#category").DataTable();
        });
    </script>
@endsection
