@extends('layouts.master')
@section('custom-css')
    <style>
        fieldset{
                border : 2px solid #123211 !important;
                border-top-color : #123211 !important;
                padding: 10px !important;
        }
       legend {
            width: auto;
       }

       @media print{
            .card-header{
                 display: none;
            }
            .footer-print-area{
                 display: none;
            }
       }
    </style>
@endsection
@section('content')
    <div class="row">
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-0">Pupils Details  <a href="#" class="btn btn-danger printProfile" title="Print Details"><i class="fas fa-print txt-light"></i></a></h6>
                        </div>
                        <div class="text-right">
                            @can('feeding-list')
                                <a href="{{ route('feedings.index') }}" class="btn btn-success btn-sm mr-1"><i
                                        class="fas fa-align-justify mr-1"></i>Pupils List</a>
                            @endcan
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row form-group">
                        <div class="col-md-2">Date</div>
                        <div class="col-md-1">:</div>
                        <div class="col-md-8"> {{ $feeding->feeding_date }}</div>
                    </div>
            
                    <div class="row form-group">
                        <div class="col-md-2">Manager Name</div>
                        <div class="col-md-1">:</div>
                        <div class="col-md-8">{{ \App\User::get_user_name($feeding->manager_id) }}</div>
                    </div>

                    <div class="row form-group">
                        <div class="col-md-2">Cook Name</div>
                        <div class="col-md-1">:</div>
                        <div class="col-md-8">{{ $feeding->cooks->full_name }}</div>
                    </div>
                    
                    <div class="row form-group">
                        <div class="col-md-2">Aggregator Name</div>
                        <div class="col-md-1">:</div>
                        <div class="col-md-8">{{ $feeding->aggregator->company_name }}</div>
                    </div>

                    <div class="row form-group">
                        <div class="col-md-2">School Name</div>
                        <div class="col-md-1">:</div>
                        <div class="col-md-8"> {{ $feeding->school->name }}</div>
                    </div>

                    <div class="row form-group">
                        <div class="col-md-2">Day</div>
                        <div class="col-md-1">:</div>
                        <div class="col-md-8"> {{ $feeding->day }}</div>
                    </div>

                    <div class="row form-group">
                        <div class="col-md-2">Item Name</div>
                        <div class="col-md-1">:</div>
                        <div class="col-md-8"> {{  $feeding->items }}</div>
                    </div>

                    <div class="row form-group">
                        <div class="col-md-2">Unit Cost</div>
                        <div class="col-md-1">:</div>
                        <div class="col-md-8"> {{  $feeding->unit_cost }}</div>
                    </div>

                    <div class="row form-group">
                        <div class="col-md-2">Total Pupils</div>
                        <div class="col-md-1">:</div>
                        <div class="col-md-8"> {{  $feeding->pupils }}</div>
                    </div>

                    <div class="row form-group">
                        <div class="col-md-2">Amount Per Day</div>
                        <div class="col-md-1">:</div>
                        <div class="col-md-8"> {{  $feeding->amount_per_day }}</div>
                    </div>

                    <div class="row form-group">
                        <div class="col-md-2">Amount For 20 Days</div>
                        <div class="col-md-1">:</div>
                        <div class="col-md-8"> {{  $feeding->amount_of_20_days }}</div>
                    </div>


                    <div class="row form-group">
                        <div class="col-md-2">Total</div>
                        <div class="col-md-1">:</div>
                        <div class="col-md-8"> {{  $feeding->total }}</div>
                    </div>

                    <div class="row form-group">
                        <div class="col-md-2">Payable Amount</div>
                        <div class="col-md-1">:</div>
                        <div class="col-md-8"> {{  $feeding->payable_amount }}</div>
                    </div>

                    <div class="row form-group">
                        <div class="col-md-2">Paid Amount</div>
                        <div class="col-md-1">:</div>
                        <div class="col-md-8"> {{  $feeding->paid }}</div>
                    </div>     

                    <div class="row form-group">
                        <div class="col-md-2">Status</div>
                        <div class="col-md-1">:</div>
                        <div class="col-md-8"> {{$feeding->status }}</div>
                    </div>
            
                   
                </div>
            </div>
        </div>
    </div>
@endsection

@section('custom-js')
      <script>
           $(document).ready(function(){
                 $('.printProfile').click(function(){
                      window.print();
                 })
           })
      </script>
@endsection
