@extends('layouts.app')

@section('content')
<div class="container">

  @include('slider')


    <div class="container mt-100 mt-60">
        {{-- <div class="row">
            <div class="col-12 text-center">
                <div class="section-title mb-4 pb-2">
                    <h4 class="title mb-4">Latest Blog &amp; News</h4>
                    <p class="text-muted para-desc mx-auto mb-0">Build responsive, mobile-first projects on the web with the world's most popular front-end component library.</p>
                </div>
            </div><!--end col-->
        </div><!--end row--> --}}

        <div class="row">

            @foreach($blogs as $blog)
          
            <div class="col-lg-4 col-md-6 mt-4 pt-2"> 
                <div class="card" style="min-height: 400px;">
                    <img src="{{ $blog->thumbnail }}" class="card-img-top" alt="...">
                   
                    <div class="card-body">
                       <small class="text-muted float-right">{{ \Carbon\Carbon::parse($blog->created_at)->format('d M, Y') }}</small>
                      <h2 class="card-title" style="font-size: 18px"><a href="{{ url('details', $blog->slug) }}" class="text-decoration-none">{{ Str::limit($blog->title, 50, '...') }}</a></h2>
                      <p class="card-text">{!! Str::limit($blog->title, 100, '...') !!}</p>
                      <a href="{{ url('details', $blog->slug) }}" class="btn btn-primary">Read More</a>
                    </div>
                  </div>
    
              </div><!--end col-->
            @endforeach
        </div><!--end row-->
    </div>
</div>
@endsection
