@extends('layouts.master')
@section('content')

    <div class="row">
        <div class="col-sm-12 col-md-12">
            <div class="card ">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="fs-17 font-weight-600 mb-0">List of Program Manager</h6>
                        </div>
                        <div class="text-right">
                            @can('program-manager.create')
                                <a href="{{ route('program-manager.create') }}" class="btn btn-success btn-sm mr-1"><i
                                        class="fas fa-plus mr-1"></i>Add program-manager</a>
                            @endcan
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table display table-bordered table-striped table-hover custom-table" id="category">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Photo</th>
                                    <th>Name</th>
                                    <th>Gender</th>
                                    <th>Date Of Birth</th>
                                    <th>Phone</th>
                                    <th>School</th>
                                    <th>Students</th>
                                    <th>Status</th>
                                    @if(auth()->user()->can('program-manager.edit') || auth()->user()->can('program-manager.delete'))
                                    <th>Action</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>

                                @foreach ($managers as $manager)
                                    <tr>
                                        <td>{{ $loop->index + 1 }}</td>
                                        <td><img src="{{ $manager->photo }}" alt="" width="65px" height="80px"></td>
                                        <td>{{ $manager->first_name }} {{ $manager->middle_name }}</td>
                                        <td>{{ $manager->gender }}</td>
                                        <td>{{ $manager->dob }}</td>
                                        <td>{{ $manager->phone }}</td>
                                        <td>{{ $manager->school->name }}</td>
                                        <td>{{ $manager->students }}</td>
                                        <td>{{ $manager->is_active == 1 ? 'Active' : 'Inactive' }}</td>

                                        <td class="form-inline">
                                            @can('program-manager.edit')
                                                <a href="{{ route('program-manager.edit', $manager->id) }}"
                                                    class="btn btn-success btn-xs" title="Update" style="margin-right:3px"><i
                                                        class="fas fa-edit"></i></a>
                                            @endcan
                                            @can('program-manager.delete')
                                                {!! Form::open(['method' => 'DELETE', 'route' => ['program-manager.destroy', $manager->id]]) !!}
                                                {{ Form::button('<i class="fa fa-trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-xs', 'id' => 'delete', 'title' => 'Delete']) }}
                                                {!! Form::close() !!}
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
@section('custom-js')
    <script>
        $(document).ready(function() {
            $("#category").DataTable();
        });
    </script>
@endsection
