@extends('layouts.master')

@section('title', 'Payment detail')

@section('content')
    <div class="row">
        {{--table--}}
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-0">Payment Record</h6>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table display table-bordered table-striped table-hover custom-table" id="category">
                            <thead>
                            <tr>
                                <th>SL</th>
                                <th>Day</th>
                                <th>Manager Name</th>
                                <th>State Name</th>
                                <th>Aggregator Name</th>
                                <th>Cook Amount</th>
                                <th>Aggregator Amount</th>
                                <th>Cooks Amount</th>
                                <th>Aggregator Amount</th>
                                <th>Total Amount</th>
                                <th>Status</th>
                                <th>Created At</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach ($data as $key => $record)
                                @php
                                    $manager_name = \App\User::where('id','=',$record->manager_id)->first();
                                @endphp
                                <tr>
                                    <td>{{ $key+1 }}</td>
                                    <td>{{ $record->day }}</td>
                                    <td>{{ $manager_name->name }}</td>
                                    <td>{{ $manager_name->state }}</td>
                                    <td>{{ $record->aggregator_name == "" ? "None" : $record->aggregator_name }}</td>
                                    <td>{{ $record->cook_amount }}</td>
                                    <td>{{ $record->aggregator_amount }}</td>
                                    <td>{{ $record->total_cook_amount }}</td>
                                    <td>{{ $record->total_aggregator_amount }}</td>
                                    <td>{{ $record->total_amount }}</td>
                                    <td>{{ $status }}</td>
                                    <td>{{ $record->created_at }}</td>
                                </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        {{--table end--}}
    </div>
@endsection
@section('custom-js')
    <script>
        $('#category').DataTable( {
            "info":     false,
            dom: 'Bfrtip',
            buttons: [
                'copyHtml5', 'excelHtml5', 'pdfHtml5','csvHtml5'
            ]
        } );
    </script>
@endsection
