@extends('layouts.master')

@section('title', 'Withdraw Request')

@section('content')

    <div class="row">
        {{--table--}}
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-0">Withdraw request</h6>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table display table-bordered table-striped table-hover custom-table" id="category">
                            <thead>
                            <tr>
                                <th>SL</th>
                                <th>Manager Name</th>
                                <th>State Name</th>
                                <th>Cooks Amount</th>
                                <th>Aggregator Amount</th>
                                <th>Withdraw Amount</th>
                                <th>Status</th>
                                <th>Requested At</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach ($data as $key => $record)
                                @php
                                    $manager_name = \App\User::where('id','=',$record->manager_id)->first();
                                @endphp
                                <tr>
                                    <td>{{ $key+1 }}</td>
                                    <td>{{ $manager_name->name }}</td>
                                    <td>{{ $manager_name->state }}</td>
                                    <td>{{ $record->cook_amount }}</td>
                                    <td>{{ $record->aggregator_amount }}</td>
                                    <td>{{ $record->withdraw_amount }}</td>
                                    <td>{{ $record->status }}</td>
                                    <td>{{ $record->created_at->diffForHumans() }}</td>
                                    @if(auth()->user()->user_type == "Admin")
                                    <td width="80px">
                                        <a class="btn-link" href="{{route('withdraw.show',$record->id)}}">Approve</a> |
                                        <a class="btn-link" href="{{route('withdraw.detail',$record->id)}}"><i class="fa fa-eye"></i></a> |
                                        <a class="btn-link" href="{{route('withdraw.edit',$record->id)}}"><i class="fa fa-pencil-alt"></i></a> |
                                        <a class="btn-link" href="{{route('w.delete',$record->id)}}"><i class="fa fa-trash"></i></a>
                                    </td>
                                        @else
                                        <td width="80px">
                                            <a class="btn-link" href="{{route('withdraw.detail',$record->id)}}"><i class="fa fa-eye"></i></a> |
                                            <a class="btn-link" href="{{route('withdraw.edit',$record->id)}}"><i class="fa fa-pencil-alt"></i></a> |
                                            <a class="btn-link" href="{{route('w.delete',$record->id)}}"><i class="fa fa-trash"></i></a>
                                        </td>
                                        @endif
                                </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        {{--table end--}}
    </div>
@endsection
@section('custom-js')
        <script>
            $(document).ready(function() {
                $("#category").DataTable({
                    "info":     false,
                    dom: 'Bfrtip',
                    buttons: [
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy',
                            title: 'NSFRS',
                            exportOptions: {
                                columns: ':not(:last-child)',
                            }
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Excel',
                            title: 'NSFRS',
                            exportOptions: {
                                columns: ':not(:last-child)',
                            }
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'PDF',
                            title: 'NSFRS',
                            exportOptions: {
                                columns: ':not(:last-child)',
                            }
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'CSV',
                            title: 'NSFRS',
                            exportOptions: {
                                columns: ':not(:last-child)',
                            }
                        }
                    ],
                });
            });
        </script>
@endsection
