@extends('layouts.master')
@section('content')

    <div class="row">
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-0">Add new School</h6>
                        </div>
                        <div class="text-right">
                            @can('school-list')
                                <a href="{{ route('school.index') }}" class="btn btn-success btn-sm mr-1"><i
                                        class="fas fa-align-justify mr-1"></i>School List</a>
                            @endcan
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    {!! Form::open(['route' => 'school.store', 'class' => 'form-horizontal']) !!}

                    @include('school.fields')

                    <div class="row form-group">
                        <div class="col-md-4"></div>
                        <div class="col-md-8">
                            {{ Form::reset('Clear', ['class' => 'btn btn-warning']) }}
                            {{ Form::submit('Create', ['class' => 'btn btn-primary']) }}</div>
                    </div>

                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>


@endsection

