
<div class="row form-group">
    <div class="col-md-2">{!! Html::decode(Form::label('name', 'Name of School <strong class="text-danger"> * </strong>')) !!}</div>
    <div class="col-md-6"> {{ Form::text('name', null, ['class' => 'form-control', 'required']) }}</div>
</div>

<div class="row form-group">
    <div class="col-md-2">{!! Html::decode(Form::label('name', 'Head Master <strong class="text-danger"> </strong>')) !!}</div>
    <div class="col-md-6"> {{ Form::text('contact_person', null, ['class' => 'form-control']) }}</div>
</div>

<div class="row form-group">
    <div class="col-md-2">{!! Html::decode(Form::label('address', 'Address of School <strong class="text-danger">  </strong>')) !!}</div>
    <div class="col-md-6"> {{ Form::text('address', null, ['class' => 'form-control']) }}</div>
</div>

<div class="row form-group">
    <div class="col-md-2">{!! Html::decode(Form::label('state', 'State <strong class="text-danger"> * </strong>')) !!}</div>
    <div class="col-md-6"> {{ Form::select('state', $states, null, ['class' => 'form-control', 'id' => 'state', 'placeholder' => '--please select--', 'required']) }}</div>
</div>



@if (Request::route()->named('school.edit'))
<div class="row form-group">
    <div class="col-md-2">{!! Html::decode(Form::label('lga', 'LGA <strong class="text-danger"> * </strong>')) !!}</div>
    <div class="col-md-6"> {{ Form::select('lga', $lga, null, ['class' => 'form-control', 'id' => 'lga', 'placeholder' => '--state select first--', 'required']) }}</div>
</div> 
@else  
<div class="row form-group">
    <div class="col-md-2">{!! Html::decode(Form::label('lga', 'LGA <strong class="text-danger"> * </strong>')) !!}</div>
    <div class="col-md-6"> {{ Form::select('lga', [], null, ['class' => 'form-control', 'id' => 'lga', 'placeholder' => '--state select first--', 'required']) }}</div>
</div>   
@endif

<div class="row form-group">
    <div class="col-md-2">{!! Html::decode(Form::label('phone', 'Head Master Phone Number <strong class="text-danger">  </strong>')) !!}</div>
    <div class="col-md-6"> {{ Form::text('phone', null, ['class' => 'form-control']) }}</div>
</div>

<div class="row form-group">
    <div class="col-md-2">{!! Html::decode(Form::label('students', 'Number of students <strong class="text-danger"> * </strong>')) !!}</div>
    <div class="col-md-6"> {{ Form::number('students', null, ['class' => 'form-control', 'required']) }}</div>
</div>

{{-- <div class="row form-group">
    <div class="col-md-2">{!! Html::decode(Form::label('is_active', 'Status <strong class="text-danger"> * </strong>')) !!}</div>
    <div class="col-md-6"> {{ Form::select('is_active', [1 => 'Active',0 => 'Inactive'], null, ['class' => 'form-control', 'required', 'id' => 'is_active'] ) }} </div>
</div> --}}

@if(auth()->user()->hasrole('Admin'))
<div class="row form-group">
    <div class="col-md-2">{{ Form::label('status', 'Status') }}</div>
    <div class="col-md-6"> {{ Form::select('status', \App\Helpers\StaticData::account_status(),null, ['class' => 'form-control'] ) }} </div>
</div>

@else   
<div class="row form-group">
    <div class="col-md-2">{{ Form::label('status', 'Status') }}</div>
    <div class="col-md-6"> {{ Form::select('status', [ 'Pending' => 'Pending'],null, ['class' => 'form-control'] ) }} </div>
</div>
@endif
@section('custom-js')
    <script>
         $(document).ready(function(){
            $('#state').select2();
            let CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
             // get state name
             let state_name = '';
             
             $("#state").on('change', function() {
                state_name = $(this).val();
                })
                // state name wise lga selections
                $("#lga").select2({
                    ajax: {
                        url: "{!! url('get-lga') !!}",
                        type: "get",
                        dataType: 'json',
                        //   delay: 250,
                        data: function(params) {
                            return {
                                _token: CSRF_TOKEN,
                                search: params.term, // search term
                                state: state_name, // search term
                            };
                        },
                        processResults: function(response) {
                            return {
                                results: response
                            };
                        },
                        cache: true
                    }
                })
         })
    </script>
@endsection
