@extends('layouts.master')
@section('content')

    <div class="row">
        <div class="col-sm-12 col-md-12">
            <div class="card ">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="fs-17 font-weight-600 mb-0">List of School</h6>
                        </div>
                        <div class="text-right">
                            @can('school-create')
                                <a href="{{ route('school.create') }}" class="btn btn-success btn-sm mr-1"><i
                                        class="fas fa-plus mr-1"></i>Add New School</a>
                            @endcan
                        </div>
                    </div>
                </div>
                <div class="card-body">

                 @can('upload-school')
                 <div class="row mb-4">
                    <div class="col-md-3">
                      @if(auth()->user()->hasrole('Admin'))
                      <a href="{{ asset('excel_demo/school_sample_file_for_admin.xls') }}" class="btn btn-primary" download> <i class="fas fa-download"></i> Download Sample File</a>
                      @else  
                      <a href="{{ asset('excel_demo/school_sample_file.xls') }}" class="btn btn-primary" download> <i class="fas fa-download"></i> Download Sample File</a>
                      @endif
                    </div>
                   
                </div>
                {!! Form::open(['url' => 'import-school', 'method' => 'POST', 'class' => 'form-horizontal', 'files' => true]) !!}
                  <div class="row form-group">

                    {{ Form::label('', 'Upload Excel File') }}
                    <div class="col-md-4 input-group mb-3"> 
                        {{ Form::file('select_file', ['class' => 'btn btn-default', 'required']) }}
                        @if($errors->has('select_file'))
                        <span class="help-block" style="display:block">
                         <strong class="text-danger">{{ $errors->first('select_file') }}</strong>
                       </span>
                       @endif
                        <div class="input-group-append">
                          {{ Form::submit('Submit', ['class' => 'btn btn-primary']) }}
                        </div>
                      </div>

                </div>
                {!! Form::close() !!}
                 @endcan

                    <div class="table-responsive">
                        <table class="table display table-bordered table-striped table-hover custom-table" id="category">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Name</th>
                                    <th>Head Name</th>
                                    <th>Address</th>
                                    <th>State</th>
                                    <th>LGA</th>
                                    <th>Phone</th>
                                    <th>Students</th>
                                    <th>Status</th>
                                    @if(auth()->user()->can('school-edit') || auth()->user()->can('school-delete'))
                                    <th>Action</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                            @php
                                $i = ($schools->perPage() * ($schools->currentPage() - 1)) + 1;
                            @endphp
                                @foreach ($schools as $school)
                                    <tr>
                                        <td>{{ $i++ }}</td>
                                        <td>{{ $school->name }}</td>
                                        <td>{{ $school->contact_person }}</td>
                                        <td>{{ $school->address }}</td>
                                        <td>{{ \App\State::get_state($school->state) }}</td>
                                        <td>{{ $school->lga }}</td>
                                        <td>{{ $school->phone }}</td>
                                        <td>{{ $school->students }}</td>
                                        {{-- <td>{{ $school->is_active == 1 ? 'Active' : 'Inactive' }}</td> --}}
                                        <td>{{ $school->status }}</td>
                                        @if(auth()->user()->can('school-edit') || auth()->user()->can('school-delete'))
                                        <td class="form-inline">
                                            @can('school-edit')
                                                <a href="{{ route('school.edit', $school->id) }}"
                                                    class="btn btn-success btn-xs" title="Update" style="margin-right:3px"><i
                                                        class="fas fa-edit"></i></a>
                                            @endcan
                                            @can('school-delete')
                                                {!! Form::open(['method' => 'DELETE', 'route' => ['school.destroy', $school->id]]) !!}
                                                {{ Form::button('<i class="fa fa-trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-xs', 'id' => 'delete', 'title' => 'Delete']) }}
                                                {!! Form::close() !!}
                                            @endcan
                                        </td>
                                        @endcan
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                     <div class="row text-center">
                         <div class="col-md-12 text-center">
                             {{ $schools->links() }}
                         </div>
                     </div>
                </div>
            </div>
        </div>
    </div>

@endsection
@section('custom-js')
    <script>
        $(document).ready(function() {
            $("#category").DataTable({
                "paging":   true,
                "info":     false
            });
        });
    </script>
@endsection
