@extends('layouts.master')
@section('content')

    <div class="row">
        <div class="col-sm-12 col-md-12">
            <div class="card ">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="fs-17 font-weight-600 mb-0">List of {{ request()->path() }}</h6>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table display table-bordered table-striped table-hover custom-table" id="category">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Photo</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>State</th>
                                    <th>Role</th>
                                    <th>Expire At</th>
                                </tr>
                            </thead>
                            <tbody>

                                @foreach ($state_admins as $state_admin)
                                    <tr>
                                        <td>{{ $loop->index + 1 }}</td>
                                        <td><img src="{{ $state_admin->photo }}" height="40px" width="60px" alt=""></td>
                                        <td>{{ $state_admin->name }}</td>
                                        <td>{{ $state_admin->email }}</td>
                                        <td>{{ $state_admin->state }}</td>
                                        <td>
                                            @if(!empty($state_admin->getRoleNames()))
                                                @foreach($state_admin->getRoleNames() as $v)
                                                    <label class="badge badge-success">{{ $v }}</label>
                                                @endforeach
                                            @endif
                                        </td>
                                        <td>{{ $state_admin->expired_at }}</td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
@section('custom-js')
    <script>
        $(document).ready(function() {
            $("#category").DataTable();
        });
    </script>
@endsection
