@extends('layouts.master')
@section('content')

    <div class="row">
        <div class="col-sm-12 col-md-12">
            <div class="card ">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="fs-17 font-weight-600 mb-0">List of Suspend Request</h6>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table display table-bordered table-striped table-hover custom-table" id="category">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Date</th>
                                    <th>Type</th>
                                    <th>Name</th>
                                    <th>Reason</th>
                                    <th>Status</th>
                                    @if(auth()->user()->can('suspend'))
                                    <th>Action</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>

                                @foreach ($suspends as $suspend)
                                    <tr>
                                        <td>{{ $loop->index + 1 }}</td>
                                        <td>{{ \Carbon\Carbon::parse($suspend->created_at)->toDateString() }}</td>
                                        <td>{{ $suspend->type }}</td>
                                        <td>
                                            @if($suspend->type =='Aggregators')
                                                {{ \App\Aggregator::get_name($suspend->cooks_aggregators_id) }}
                                                @elseif($suspend->type =='Cooks')
                                                {{ \App\Cooks::get_name($suspend->cooks_aggregators_id) }}
                                            @endif
                                        </td>
                                        <td>{{ $suspend->reason }}</td>
                                        <td>{{ $suspend->status }}</td>
                                        @can('suspend')
                                        <td class="form-inline">
                                            <a href="{{ url('suspend-approved', $suspend->id) }}" class="btn btn-success btn-xs" title="Approve" style="margin-right:3px">Approve</a>
                                            <a href="{{ url('suspend-declined', $suspend->id) }}" class="btn btn-warning btn-xs" title="Decline" style="margin-right:3px">Decline</a>
                                            <a href="{{ url('suspend-delete', $suspend->id) }}" class="btn btn-danger btn-xs" id="delete" title="Delete" style="margin-right:3px">Delete</a>
                                        </td>
                                        @endcan
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
@section('custom-js')
    <script>
        $(document).ready(function() {
            $("#category").DataTable();
        });
    </script>
@endsection
