@extends('layouts.master')

@section('title', 'Edit User')

@section('content')
    <div class="row">
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-0">Change Password</h6>
                        </div>
                        <div class="text-right">
                            <a href="{{ url('/my-profile') }}" class="btn btn-success btn-sm mr-1"><i
                                    class="fas fa-align-justify mr-1"></i>Back To Profile</a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    {!! Form::open(['url' => 'save-new-password', 'method' => 'PUT']) !!}
                    <div class="row form-group">
                        <div class="col-md-2"><strong>New Password:</strong></div>
                        <div class="col-md-6">
                            <input id="password" type="password"
                                class="form-control @error('password') is-invalid @enderror" name="password" required
                                autocomplete="new-password" placeholder="New Password">

                            @error('password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <div class="row form-group">
                        <div class="col-md-2">
                            <strong>Confirm Password:</strong>
                        </div>
                        <div class="col-md-6">
                            <input id="password-confirm" type="password" class="form-control" name="password_confirmation"
                                required autocomplete="new-password" placeholder="Confirm Password">
                        </div>
                    </div>
                    <div class="row form-group">
                        <div class="col-md-4"></div>
                        <div class="col-md-8">
                            {{-- {{ Form::reset('Reset', ['class' => 'btn btn-warning']) }} --}}
                            {{ Form::submit('Submit', ['class' => 'btn btn-primary']) }}</div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
    </div>

@endsection
