@extends('layouts.master')

@section('custom-css')
    <style>
        #previewImg{
                height: 250px;
                width: 300px;
                margin-top: 20px;
        }
    </style>
@endsection 

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-lg-8 margin-tb">
                    <div class="pull-left">
                        <h2>Create New User
                            <a class="btn btn-primary" href="{{ route('users.index') }}"> Back</a>
                        </h2>
                    </div>
                </div>
            </div>
        
        
            @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <strong>Whoops!</strong> There were some problems with your input.<br><br>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
        
        
        
            {!! Form::open(array('route' => 'users.store','method'=>'POST', 'files' => true)) !!}
            <div class="row">
                <div class="col-xs-8 col-sm-12 col-md-8">
                    <div class="form-group">
                        <strong>Name <b class="text-danger">*</b></strong>
                        {!! Form::text('name', null, array('placeholder' => 'Name','class' => 'form-control', 'required')) !!}
                    </div>
                </div>
                <div class="col-xs-8 col-sm-12 col-md-8">
                    <div class="form-group">
                        <strong>Email <b class="text-danger">*</b></strong>
                        {!! Form::text('email', null, array('placeholder' => 'Email','class' => 'form-control', 'required')) !!}
                    </div>
                </div>
                <div class="col-xs-8 col-sm-12 col-md-8">
                    <div class="form-group">
                        <strong>Profile Picture</strong>
                        {!! Form::file('photo', array('class' => 'form-control', 'id' => 'uploadImg')) !!}

                            @if($errors->has('photo'))
                            <span class="help-block">
                                <strong class="text-danger">
                                    {{ $errors->first('photo') }}
                                </strong>
                            </span>
                            @endif

                            <img id="previewImg" src="" alt="Image Preview">
                    </div>
                </div>

                <div class="col-xs-8 col-sm-12 col-md-8">
                    <div class="form-group">
                        <strong>State <b class="text-danger">*</b></strong>
                        {{ Form::select('state', $states, null, ['class' => 'form-control', 'placeholder' => '--please select--', 'id' => 'state', 'required'] ) }}
                    </div>
                </div>

                <div class="col-xs-8 col-sm-12 col-md-8">
                    <div class="form-group">
                        <strong>Expire After</strong>
                        {{ Form::select('expired_at',  \App\Helpers\StaticData::profile_expire(),null, ['class' => 'form-control', 'placeholder' => '--please select--', 'id' => 'expired_at'] ) }}
                    </div>
                </div>

                <div class="col-xs-8 col-sm-12 col-md-8">
                    <div class="form-group">
                        <strong>Password <b class="text-danger">*</b></strong>
                        <input id="password" type="password"
                        class="form-control @error('password') is-invalid @enderror" name="password" required
                        autocomplete="new-password" placeholder="New Password">

                    @error('password')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
                    </div>
                </div>
                <div class="col-xs-8 col-sm-12 col-md-8">
                    <div class="form-group">
                        <strong>Confirm Password <b class="text-danger">*</b></strong>
                        <input id="password-confirm" type="password" class="form-control" name="confirm-password"
                                required autocomplete="new-password" placeholder="Confirm Password">
                    </div>
                </div>
                <div class="col-xs-8 col-sm-12 col-md-8">
                    <div class="form-group">
                        <strong>Role <b class="text-danger">*</b></strong>
                        {!! Form::select('roles[]', $roles,[], array('class' => 'form-control','multiple', 'required')) !!}
                    </div>
                </div>
                <div class="col-xs-8 col-sm-12 col-md-8 text-center">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </div>
            {!! Form::close() !!}
        </div>
    </div>

@endsection

@section('custom-js')
<script>
    $("#state").select2();
    $("#expired_at").select2();
    $(document).ready(function(){
          $("#previewImg").hide();
            $("#uploadImg").on('change', function(){
                let file = $(this).get(0).files[0];

        if(file){
            $("#previewImg").show();
            let reader = new FileReader();

            reader.onload = function(){
                $("#previewImg").attr("src", reader.result);
            }
            reader.readAsDataURL(file);
            }
             })
      })
</script>
@endsection
