

<?php $__env->startSection('title', 'Withdraw Request'); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-0">Withdraw request</h6>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="datatables-users table border-top dataTable no-footer dtr-column" id="withdraw">
                            <thead>
                            <tr>
                                <th>SL</th>
                                <th>Month</th>
                                <th>Manager Name</th>
                                <th>State Name</th>
                                <th>Cooks Amount</th>
                                <th>Aggregator Amount</th>
                                <th>Withdraw Amount</th>
                                <th>Status</th>
                                <th>Requested At</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $manager_name = \App\User::where('id','=',$record->manager_id)->first();
                                ?>
                                <tr>
                                    <td><?php echo e($key+1); ?></td>
                                    <td><?php echo date("F", strtotime($record['withdraw_month'])); ?></td>
                                    <td><?php echo e($manager_name->name); ?></td>
                                    <td><?php echo e($manager_name->state); ?></td>
                                    <td><?php echo e($record->cook_amount); ?></td>
                                    <td><?php echo e($record->aggregator_amount); ?></td>
                                    <td><?php echo e($record->withdraw_amount); ?></td>
                                    <?php if($record->status =="Approved"): ?>
                                    <td><span class="badge bg-label-success" text-capitalized="">Approved</span></td>
                                    <?php endif; ?>
                                    <?php if($record->status =="Pending"): ?>
                                    <td><span class="badge bg-label-warning" text-capitalized="">Pending</span></td>
                                    <?php endif; ?>
                                    <?php if($record->status =="Rejected"): ?>
                                    <td><span class="badge bg-label-warning" text-capitalized="">Rejected</span></td>
                                    <?php endif; ?>
                                    <td><?php echo e($record->created_at->diffForHumans()); ?></td>
                                    <?php if(auth()->user()->user_type == "Admin"): ?>
                                    <td width="170px">
                                        <a class="btn-link" href="<?php echo e(route('withdraw.detail',$record->id)); ?>"><i class="ti ti-eye ti-sm mx-2"></i></a>
                                        <a class="btn-link" href="<?php echo e(route('withdraw.edit',$record->id)); ?>"><i class="ti ti-edit ti-sm me-2"></i></a>
                                        <a class="btn-link" href="<?php echo e(route('w.delete',$record->id)); ?>"><i class="ti ti-trash ti-sm mx-2"></i></a>
                                        <a class="btn-link" href="<?php echo e(route('withdraw.show',$record->id)); ?>"><i class="ti ti-check ti-sm mx-2"></i></a>
                                    </td>
                                        <?php else: ?>
                                        <td width="170px">
                                            <a class="btn-link" href="<?php echo e(route('withdraw.detail',$record->id)); ?>"><i class="ti ti-eye ti-sm mx-2"></i></a>
                                            <a class="btn-link" href="<?php echo e(route('withdraw.edit',$record->id)); ?>"><i class="ti ti-edit ti-sm me-2"></i></a>
                                            <a class="btn-link" href="<?php echo e(route('w.delete',$record->id)); ?>"><i class="ti ti-trash ti-sm mx-2"></i></a>
                                        </td>
                                        <?php endif; ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-js'); ?>
        <script>
            $(document).ready(function() {
                // $("#withdraw").DataTable({
                //     "info":     false,
                //     dom: 'Bfrtip',
                //     buttons: [
                //         {
                //             extend: 'copyHtml5',
                //             text: 'Copy',
                //             titleAttr: 'Copy',
                //             title: 'NSFRS',
                //             exportOptions: {
                //                 columns: ':not(:last-child)',
                //             }
                //         },
                //         {
                //             extend: 'excelHtml5',
                //             text: 'Excel',
                //             titleAttr: 'Excel',
                //             title: 'NSFRS',
                //             exportOptions: {
                //                 columns: ':not(:last-child)',
                //             }
                //         },
                //         {
                //             extend: 'pdfHtml5',
                //             text: 'PDF',
                //             titleAttr: 'PDF',
                //             title: 'NSFRS',
                //             exportOptions: {
                //                 columns: ':not(:last-child)',
                //             }
                //         },
                //         {
                //             extend: 'csvHtml5',
                //             text: 'CSV',
                //             titleAttr: 'CSV',
                //             title: 'NSFRS',
                //             exportOptions: {
                //                 columns: ':not(:last-child)',
                //             }
                //         }
                //     ],
                // });
            });
        </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\NHG-backup\resources\views/payment/withdraw.blade.php ENDPATH**/ ?>