<form method="POST" action="<?php echo e($formAction ?? ''); ?>" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>

    <div class="row form-group">
        <div class="col-md-2">
            <label for="first_name"><strong>First Name</strong> <span class="text-danger">*</span></label>
        </div>
        <div class="col-md-6">
            <input type="text" name="first_name" class="form-control"
                value="<?php echo e(old('first_name', $cook->first_name ?? '')); ?>" required>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-2">
            <label for="company_name"><strong>Company Name</strong> <span class="text-danger">*</span></label>
        </div>
        <div class="col-md-6">
            <input type="text" name="company_name" class="form-control"
                value="<?php echo e(old('company_name', $cook->company_name ?? '')); ?>" required>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-2">
            <label for="middle_name"><strong>Middle Name</strong> <span class="text-danger">*</span></label>
        </div>
        <div class="col-md-6">
            <input type="text" name="middle_name" class="form-control"
                value="<?php echo e(old('middle_name', $cook->middle_name ?? '')); ?>" required>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-2">
            <label for="last_name"><strong>Last Name</strong> <span class="text-danger">*</span></label>
        </div>
        <div class="col-md-6">
            <input type="text" name="last_name" class="form-control"
                value="<?php echo e(old('last_name', $cook->last_name ?? '')); ?>" required>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-2">
            <label for="gender"><strong>Gender</strong> <span class="text-danger">*</span></label>
        </div>
        <div class="col-md-6">
            <select name="gender" class="form-control" required>
                <option value="">Select Gender</option>
                <option value="Male" <?php echo e(old('gender', $cook->gender ?? '') == 'Male' ? 'selected' : ''); ?>>Male</option>
                <option value="Female" <?php echo e(old('gender', $cook->gender ?? '') == 'Female' ? 'selected' : ''); ?>>Female
                </option>
            </select>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-2">
            <label for="dob"><strong>Date of Birth</strong> <span class="text-danger">*</span></label>
        </div>
        <div class="col-md-6">
            <input type="date" name="dob" class="form-control" value="<?php echo e(old('dob', $cook->dob ?? '')); ?>" required>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-2">
            <label for="bank_name"><strong>Bank Name</strong> <span class="text-danger">*</span></label>
        </div>
        <div class="col-md-6">
            <input type="text" name="bank_name" class="form-control"
                value="<?php echo e(old('bank_name', $cook->bank_name ?? '')); ?>" required>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-2">
            <label for="bvn"><strong>BVN</strong> <span class="text-danger">*</span></label>
        </div>
        <div class="col-md-6">
            <input type="text" name="bvn" class="form-control" value="<?php echo e(old('bvn', $cook->bvn ?? '')); ?>" required>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-2">
            <label for="account_number"><strong>Account Number</strong> <span class="text-danger">*</span></label>
        </div>
        <div class="col-md-6">
            <input type="text" name="account_number" class="form-control"
                value="<?php echo e(old('account_number', $cook->account_number ?? '')); ?>" required>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-2">
            <label for="phone"><strong>Phone Number</strong> <span class="text-danger">*</span></label>
        </div>
        <div class="col-md-6">
            <input type="text" name="phone" class="form-control" value="<?php echo e(old('phone', $cook->phone ?? '')); ?>"
                required>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-2">
            <label for="email"><strong>Email</strong> <span class="text-danger">*</span></label>
        </div>
        <div class="col-md-6">
            <input type="email" name="email" class="form-control" value="<?php echo e(old('email', $cook->email ?? '')); ?>"
                required>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-2">
            <label for="city"><strong>City</strong> <span class="text-danger">*</span></label>
        </div>
        <div class="col-md-6">
            <input type="text" name="city" class="form-control" value="<?php echo e(old('city', $cook->city ?? '')); ?>" required>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-2">
            <label for="state"><strong>State</strong> <span class="text-danger">*</span></label>
        </div>
        <div class="col-md-6">
            <select name="state" id="state" class="form-control" required>
                <option value="">--please select--</option>
                <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($key); ?>" <?php echo e(old('state', $cook->state ?? '') == $key ? 'selected' : ''); ?>><?php echo e($value); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    </div>

    <?php if(Request::route()->named('cooks.edit')): ?>
        <div class="row form-group">
            <div class="col-md-2">
                <label for="lga"><strong>LGA</strong> <span class="text-danger">*</span></label>
            </div>
            <div class="col-md-6">
                <select name="lga" id="lga" class="form-control" required>
                    <?php $__currentLoopData = $lga; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php echo e(old('lga', $cook->lga ?? '') == $key ? 'selected' : ''); ?>><?php echo e($value); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
    <?php else: ?>
        <div class="row form-group">
            <div class="col-md-2">
                <label for="lga"><strong>LGA</strong> <span class="text-danger">*</span></label>
            </div>
            <div class="col-md-6">
                <select name="lga" id="lga" class="form-control" required>
                    <option value="">--state select first--</option>
                </select>
            </div>
        </div>
    <?php endif; ?>

    <div class="row form-group">
        <div class="col-md-2">
            <label for="school_id"><strong>School</strong> <span class="text-danger">*</span></label>
        </div>
        <div class="col-md-6">
            <select name="school_id" id="school_id" class="form-control" required>
                <option value="">--please select--</option>
            </select>
        </div>
    </div>


    <div class="row form-group">
        <div class="col-md-2">
            <label for="students"><strong>Number of Pupils</strong> <span class="text-danger">*</span></label>
        </div>
        <div class="col-md-6">
            <input type="number" name="students" class="form-control"
                value="<?php echo e(old('students', $cook->students ?? '')); ?>" required>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-2">
            <label for="amount_of_feed_per_pupil"><strong>Amount of Feed Per Pupil</strong> <span
                    class="text-danger">*</span></label>
        </div>
        <div class="col-md-6">
            <input type="text" name="amount_of_feed_per_pupil" class="form-control"
                value="<?php echo e(old('amount_of_feed_per_pupil', $cook->amount_of_feed_per_pupil ?? '')); ?>" required>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-2">
            <label for="photo">Photo</label>
        </div>
        <div class="col-md-6">
            <input type="file" name="photo" class="form-control">
            <?php $__errorArgs = ['photo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span><strong class="text-danger"><?php echo e($message); ?></strong></span>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-2">
            <label for="status">Status</label>
        </div>
        <div class="col-md-6">
            <select name="status" class="form-control">
                <?php if(auth()->user()->hasRole('Admin')): ?>
                    <?php $__currentLoopData = \App\Helpers\StaticData::account_status(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($status); ?>" <?php echo e(old('status', $cook->status ?? '') == $status ? 'selected' : ''); ?>>
                            <?php echo e($status); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <option value="Pending" selected>Pending</option>
                <?php endif; ?>
            </select>
        </div>
    </div>

    
    <div class="row form-group">
        <div class="col-md-2"></div>
        <div class="col-md-6">
            <button type="submit" class="btn btn-primary">Save</button>
        </div>
    </div>
</form>


<?php $__env->startSection('custom-js'); ?>
    <script>
        $(document).ready(function () {
            $('#state, #lga, #school_id').select2();

            // When state changes, load LGA
            $('#state').on('change', function () {
                let state = $(this).val();
                $('#lga').html('<option value="">Loading...</option>');
                $('#school_id').html('<option value="">--please select--</option>');

                // Load LGAs
                $.ajax({
                    url: "<?php echo e(url('get-lga')); ?>",
                    method: 'GET',
                    data: {
                        state: state
                    },
                    success: function (data) {
                        $('#lga').html('<option value="">--please select--</option>');
                        data.forEach(item => {
                            $('#lga').append(`<option value="${item.id}">${item.text}</option>`);
                        });
                    }
                });
            });

            // When LGA changes, load schools
            $('#lga').on('change', function () {
                let state = $('#state').val();
                let lga = $(this).val();
                $('#school_id').html('<option value="">Loading...</option>');

                // Load schools
                $.ajax({
                    url: "<?php echo e(url('get-schools-by-state-lga')); ?>",
                    method: 'GET',
                    data: {
                        state: state,
                        lga: lga
                    },
                    success: function (data) {
                        $('#school_id').html('<option value="">--please select--</option>');
                        data.forEach(item => {
                            $('#school_id').append(`<option value="${item.id}">${item.name}</option>`);
                        });
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?><?php /**PATH C:\laragon\www\NHG-backup\resources\views/cook/fields.blade.php ENDPATH**/ ?>