<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-sm-12 col-md-12">
        <div class="card ">
            <div class="card-header py-2">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="fs-17 font-weight-600 mb-0">List of School</h6>
                    </div>
                    <div class="text-right">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('school-create')): ?>
                            <a href="<?php echo e(route('school.create')); ?>" class="btn btn-success btn-sm mr-1"><i
                                    class="fas fa-plus mr-1"></i>Add New School</a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="card-body">

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('upload-school')): ?>
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <?php if(auth()->user()->hasrole('Admin')): ?>
                                <a href="<?php echo e(asset('excel_demo/school_sample_file_for_admin.xls')); ?>" class="btn btn-primary"
                                    download> <i class="fas fa-download"></i> Download Sample File</a>
                            <?php else: ?>
                                <a href="<?php echo e(asset('excel_demo/school_sample_file.xls')); ?>" class="btn btn-primary" download> <i
                                        class="fas fa-download"></i> Download Sample File</a>
                            <?php endif; ?>
                        </div>

                    </div>
                    <?php echo Form::open(['url' => 'import-school', 'method' => 'POST', 'class' => 'form-horizontal', 'files' => true]); ?>

                    <div class="row form-group">

                        <?php echo e(Form::label('', 'Upload Excel File')); ?>

                        <div class="col-md-4 input-group mb-3">
                            <?php echo e(Form::file('select_file', ['class' => '', 'required'])); ?>

                            <?php if($errors->has('select_file')): ?>
                                <span class="help-block" style="display:block">
                                    <strong class="text-danger"><?php echo e($errors->first('select_file')); ?></strong>
                                </span>
                            <?php endif; ?>
                            <div class="input-group-append">
                                <button type="submit"
                                    class="btn btn-success buttons-collection dropdown-toggle btn-label-secondary mx-3"
                                    tabindex="0" aria-controls="DataTables_Table_0" type="button" aria-haspopup="dialog"
                                    aria-expanded="false"><span><i
                                            class="ti ti-screen-share me-1 ti-xs"></i>Submit</span><span
                                        class="dt-down-arrow"></span></button>
                            </div>
                        </div>

                    </div>


                    <?php echo Form::close(); ?>

                <?php endif; ?>

                <div class="table-responsive">
                    <table class="datatables-users table border-top dataTable no-footer dtr-column" id="category">
                        <thead>
                            <tr>
                                <th>SL</th>
                                <th>Name</th>
                                <th>Head Name</th>
                                <th>Address</th>
                                <th>State</th>
                                <th>LGA</th>
                                <th>Phone</th>
                                <th>Students</th>
                                <th>Status</th>
                                <?php if(auth()->user()->can('school-edit') || auth()->user()->can('school-delete')): ?>
                                    <th>Action</th>
                                    <th>Report</th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $i = ($schools->perPage() * ($schools->currentPage() - 1)) + 1;
                            ?>
                            <?php $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $school): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i++); ?></td>
                                <td id="school_<?php echo e($school->id); ?>"><?php echo e($school->name); ?></td>
                                <td><?php echo e($school->contact_person); ?></td>
                                <td><?php echo e($school->address); ?></td>
                                <td><?php echo e(\App\State::get_state($school->state)); ?></td>
                                <td><?php echo e($school->lga); ?></td>
                                <td><?php echo e($school->phone); ?></td>
                                <td><?php echo e($school->students); ?></td>
                                
                                <td><?php echo e($school->status); ?></td>
                                <?php if(auth()->user()->can('school-edit') || auth()->user()->can('school-delete')): ?>
                                <td class="form-inline">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('school-edit')): ?>
                                        <a href="<?php echo e(route('school.edit', $school->id)); ?>" title="Update"
                                            style="margin-right:3px"><i class="ti ti-edit ti-sm mx-2"></i></a>
                                    <?php endif; ?>
                                    <?php if(auth()->user()->user_type == "Admin"): ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('school-delete')): ?>


                                            <?php echo Form::open(['method' => 'DELETE', 'route' => ['school.destroy', $school->id], 'style' => 'display:inline-block;', 'onsubmit' => "return confirm('Are you sure you want to delete this school?');"]); ?>

                                            <?php echo e(Form::button('<i class="ti ti-trash ti-sm mx-2"></i>', ['type' => 'submit', 'class' => '', 'title' => 'Delete'])); ?>

                                            <?php echo Form::close(); ?>

                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <button type="button" onclick="set_id(<?php echo e($school->id); ?>)"
                                        class="btn btn-sm btn-outline-primary" data-toggle="modal"
                                        data-target="#exampleModal">
                                        Report
                                    </button>
                                </td>
                                <?php endif; ?>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>
                <div class="row text-center">
                    <div class="col-md-12 text-center">
                        <?php echo e($schools->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Report Against : <b class="text-danger"
                        id="school_name"></b></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="" method="post">
                <div class="modal-body">
                    <input id="school" type="hidden" name="school_id" value="">
                    <textarea name="report" class="form-control" required placeholder="Enter Report"></textarea>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary">Report</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-js'); ?>
    <script>
        function set_id(id) {
            $("#school").val(id);
            var name = $("#school_" + id).text();
            $("#school_name").text(name);
        }
        $(document).ready(function () {
            $("#category").DataTable({
                "paging": false,
                "info": false
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\NHG-backup\resources\views/school/index.blade.php ENDPATH**/ ?>